/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.item.BatteryItem;
import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.module.IModuleItem;
import com.daqem.irobot.item.module.ModuleItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_10630;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9835;
import net.minecraft.class_9875;
import org.jetbrains.annotations.NotNull;

public class RobotInventory
implements class_1263 {
    public static final int INVENTORY_SIZE = 24;
    public static final int BATTERY_SLOT_INDEX = 24;
    public static final int TASK_SLOT_INDEX = 25;
    public static final int MODULE_SLOT_1_INDEX = 26;
    public static final int MODULE_SLOT_2_INDEX = 27;
    public static final Int2ObjectMap<class_1304> EQUIPMENT_SLOT_MAPPING;
    public final IRobotEntity robot;
    private final class_2371<class_1799> items = class_2371.method_10213((int)28, (Object)class_1799.field_8037);
    private final class_10630 equipment;
    private int selected;

    public RobotInventory(IRobotEntity robot, class_10630 equipment) {
        this.robot = robot;
        this.equipment = equipment;
    }

    public static int getSelectionSize() {
        return 9;
    }

    public static boolean isHotbarSlot(int index) {
        return index >= 0 && index < 9;
    }

    public static boolean isUsableForCrafting(class_1799 stack) {
        return !stack.method_7986() && !stack.method_7942() && !stack.method_57826(class_9334.field_49631);
    }

    public void pickUpItem(class_3218 level, class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (this.robot.method_20820(level, itemStack)) {
            boolean bl = this.canAddItem(itemStack);
            if (!bl) {
                return;
            }
            this.robot.method_29499(itemEntity);
            int i = itemStack.method_7947();
            class_1799 itemStack2 = this.addItem(itemStack);
            this.robot.method_6103((class_1297)itemEntity, i - itemStack2.method_7947());
            if (itemStack2.method_7960()) {
                itemEntity.method_31472();
            } else {
                itemStack.method_7939(itemStack2.method_7947());
            }
        }
    }

    public boolean canAddItem(class_1799 stack) {
        boolean bl = false;
        for (class_1799 itemStack : this.items) {
            if (!itemStack.method_7960() && (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || itemStack.method_7947() >= itemStack.method_7914())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public class_1799 addItem(class_1799 stack) {
        class_1799 taskSlotStack;
        class_1799 batterySlotStack;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (stack.method_7909() instanceof BatteryItem && (batterySlotStack = (class_1799)this.items.get(24)).method_7960()) {
            this.items.set(24, (Object)stack.method_7971(1));
            return stack;
        }
        if (stack.method_7909() instanceof TaskItem && (taskSlotStack = (class_1799)this.items.get(25)).method_7960()) {
            this.items.set(25, (Object)stack.method_7971(1));
            return stack;
        }
        if (stack.method_7909() instanceof IModuleItem) {
            if (((class_1799)this.items.get(26)).method_7960()) {
                this.items.set(26, (Object)stack.method_7971(1));
                if (stack.method_7960()) {
                    return class_1799.field_8037;
                }
            }
            if (((class_1799)this.items.get(27)).method_7960()) {
                this.items.set(27, (Object)stack.method_7971(1));
                if (stack.method_7960()) {
                    return class_1799.field_8037;
                }
            }
        }
        class_1799 itemStack = stack.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    public List<class_1799> removeAllItems() {
        List<class_1799> list = this.items.stream().filter(itemStack -> !itemStack.method_7960()).collect(Collectors.toList());
        this.method_5448();
        return list;
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 stack) {
        for (int i = 0; i < 24; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    private void moveItemToEmptySlots(class_1799 stack) {
        for (int i = 0; i < 24; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!itemStack.method_7960()) continue;
            this.method_5447(i, stack.method_51164());
            return;
        }
    }

    private void moveItemsBetweenStacks(class_1799 stack, class_1799 other) {
        int i = this.method_58350(other);
        int j = Math.min(stack.method_7947(), i - other.method_7947());
        if (j > 0) {
            other.method_7933(j);
            stack.method_7934(j);
            this.method_5431();
        }
    }

    public int getSelectedSlot() {
        return this.selected;
    }

    public void setSelectedSlot(int slot) {
        this.selected = slot;
    }

    public class_1799 getSelectedItem() {
        return (class_1799)this.items.get(this.selected);
    }

    public class_1799 setSelectedItem(class_1799 stack) {
        return (class_1799)this.items.set(this.selected, (Object)stack);
    }

    public class_2371<class_1799> getNonEquipmentItems() {
        return this.items;
    }

    private boolean hasRemainingSpaceForItem(class_1799 destination, class_1799 origin) {
        return !destination.method_7960() && class_1799.method_31577((class_1799)destination, (class_1799)origin) && destination.method_7946() && destination.method_7947() < this.method_58350(destination);
    }

    public int getFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public boolean isFull() {
        return this.getFreeSlot() == -1;
    }

    public boolean isMainInventoryFull() {
        for (int i = 0; i < 24; ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            return false;
        }
        return true;
    }

    public void addAndPickItem(class_1799 stack) {
        int i;
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        if (!((class_1799)this.items.get(this.selected)).method_7960() && (i = this.getFreeSlot()) != -1) {
            this.items.set(i, (Object)((class_1799)this.items.get(this.selected)));
        }
        this.items.set(this.selected, (Object)stack);
    }

    public void pickSlot(int index) {
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        class_1799 itemStack = (class_1799)this.items.get(this.selected);
        this.items.set(this.selected, (Object)((class_1799)this.items.get(index)));
        this.items.set(index, (Object)itemStack);
    }

    public int findSlotMatchingItem(class_1799 stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)this.items.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int findSlotMatchingCraftingIngredient(class_6880<class_1792> item, class_1799 stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960() || !itemStack.method_41406(item) || !RobotInventory.isUsableForCrafting(itemStack) || !stack.method_7960() && !class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int j;
        for (int i = 0; i < 9; ++i) {
            j = (this.selected + i) % 9;
            if (!((class_1799)this.items.get(j)).method_7960()) continue;
            return j;
        }
        for (int ix = 0; ix < 9; ++ix) {
            j = (this.selected + ix) % 9;
            if (((class_1799)this.items.get(j)).method_7942()) continue;
            return j;
        }
        return this.selected;
    }

    private int addResource(class_1799 stack) {
        int i = this.getSlotWithRemainingSpace(stack);
        if (i == -1) {
            i = this.getFreeSlot();
        }
        return i == -1 ? stack.method_7947() : this.addResource(i, stack);
    }

    private int addResource(int slot, class_1799 stack) {
        int j;
        int k;
        int i = stack.method_7947();
        class_1799 itemStack = this.method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = stack.method_46651(0);
            this.method_5447(slot, itemStack);
        }
        if ((k = Math.min(i, j = this.method_58350(itemStack) - itemStack.method_7947())) != 0) {
            i -= k;
            itemStack.method_7933(k);
            itemStack.method_7912(5);
        }
        return i;
    }

    public int getSlotWithRemainingSpace(class_1799 stack) {
        if (this.hasRemainingSpaceForItem(this.method_5438(this.selected), stack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.method_5438(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem((class_1799)this.items.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void tick() {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            itemStack.method_7917(this.robot.method_37908(), (class_1297)this.robot, (class_1304)(i == this.selected ? class_1304.field_6173 : null));
        }
    }

    public boolean add(class_1799 stack) {
        return this.add(-1, stack);
    }

    public boolean add(int slot, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        try {
            int i;
            if (stack.method_7986()) {
                if (slot == -1) {
                    slot = this.getFreeSlot();
                }
                if (slot >= 0) {
                    this.items.set(slot, (Object)stack.method_51164());
                    ((class_1799)this.items.get(slot)).method_7912(5);
                    return true;
                }
                if (this.robot.method_56992()) {
                    stack.method_7939(0);
                    return true;
                }
                return false;
            }
            do {
                i = stack.method_7947();
                if (slot == -1) {
                    stack.method_7939(this.addResource(stack));
                    continue;
                }
                stack.method_7939(this.addResource(slot, stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            if (stack.method_7947() == i && this.robot.method_56992()) {
                stack.method_7939(0);
                return true;
            }
            return stack.method_7947() < i;
        }
        catch (Throwable var6) {
            class_128 crashReport = class_128.method_560((Throwable)var6, (String)"Adding item to inventory");
            class_129 crashReportCategory = crashReport.method_562("Item being added");
            crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
            crashReportCategory.method_578("Item data", (Object)stack.method_7919());
            crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
            throw new class_148(crashReport);
        }
    }

    public void placeItemBackInInventory(class_1799 stack) {
        this.placeItemBackInInventory(stack, true);
    }

    public void placeItemBackInInventory(class_1799 stack, boolean sendPacket) {
        while (!stack.method_7960()) {
            int i = this.getSlotWithRemainingSpace(stack);
            if (i == -1) {
                i = this.getFreeSlot();
            }
            if (i == -1) {
                this.robot.method_7329(stack, false, true);
                break;
            }
            int n = stack.method_7914() - this.method_5438(i).method_7947();
        }
    }

    public class_9835 createInventoryUpdatePacket(int slot) {
        return new class_9835(slot, this.method_5438(slot).method_7972());
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack;
        if (slot < this.items.size()) {
            return class_1262.method_5430(this.items, (int)slot, (int)amount);
        }
        class_1304 equipmentSlot = (class_1304)EQUIPMENT_SLOT_MAPPING.get(slot);
        if (equipmentSlot != null && !(itemStack = this.equipment.method_66659(equipmentSlot)).method_7960()) {
            return itemStack.method_7971(amount);
        }
        return class_1799.field_8037;
    }

    public void removeItem(class_1799 stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != stack) continue;
            this.items.set(i, (Object)class_1799.field_8037);
            return;
        }
        for (class_1304 equipmentSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            class_1799 itemStack = this.equipment.method_66659(equipmentSlot);
            if (itemStack != stack) continue;
            this.equipment.method_66660(equipmentSlot, class_1799.field_8037);
            return;
        }
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        if (slot < this.items.size()) {
            class_1799 itemStack = (class_1799)this.items.get(slot);
            this.items.set(slot, (Object)class_1799.field_8037);
            return itemStack;
        }
        class_1304 equipmentSlot = (class_1304)EQUIPMENT_SLOT_MAPPING.get(slot);
        return equipmentSlot != null ? this.equipment.method_66660(equipmentSlot, class_1799.field_8037) : class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
            if (!(this.robot.method_37908().method_8608() || slot != 26 && slot != 27)) {
                this.robot.recalculateAttributes();
            }
            return;
        }
        class_1304 equipmentSlot = (class_1304)EQUIPMENT_SLOT_MAPPING.get(slot);
        if (equipmentSlot != null) {
            this.equipment.method_66660(equipmentSlot, stack);
        }
    }

    public void method_5431() {
    }

    public void save(class_11372.class_11373<class_11343> output) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960()) continue;
            output.method_71484((Object)new class_11343(i, itemStack));
        }
    }

    public void load(class_11368.class_11369<class_11343> input) {
        this.items.clear();
        for (class_11343 itemStackWithSlot : input) {
            if (!itemStackWithSlot.method_71368(this.items.size())) continue;
            this.method_5447(itemStackWithSlot.comp_4211(), itemStackWithSlot.comp_4212());
        }
    }

    public int method_5439() {
        return this.items.size() + EQUIPMENT_SLOT_MAPPING.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        for (class_1304 equipmentSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            if (this.equipment.method_66659(equipmentSlot).method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        if (slot < this.items.size()) {
            return (class_1799)this.items.get(slot);
        }
        class_1304 equipmentSlot = (class_1304)EQUIPMENT_SLOT_MAPPING.get(slot);
        return equipmentSlot != null ? this.equipment.method_66659(equipmentSlot) : class_1799.field_8037;
    }

    public void dropAll() {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960()) continue;
            this.robot.method_7329(itemStack, true, false);
            this.items.set(i, (Object)class_1799.field_8037);
        }
        this.equipment.method_67514((class_1309)this.robot);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public boolean contains(class_1799 stack) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = (class_1799)iterator.next();
            if (itemStack.method_7960() || !class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(class_6862<class_1792> tag) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = (class_1799)iterator.next();
            if (itemStack.method_7960() || !itemStack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<class_1799> predicate) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = (class_1799)iterator.next();
            if (!predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(class_1661 playerInventory) {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.method_5447(i, playerInventory.method_5438(i));
        }
        this.setSelectedSlot(playerInventory.method_67532());
    }

    public void method_5448() {
        this.items.clear();
        this.equipment.method_67515();
    }

    public void fillStackedContents(class_9875 contents) {
        for (class_1799 itemStack : this.items) {
            contents.method_61535(itemStack);
        }
    }

    public class_1799 removeFromSelected(boolean removeStack) {
        class_1799 itemStack = this.getSelectedItem();
        return itemStack.method_7960() ? class_1799.field_8037 : this.method_5434(this.selected, removeStack ? itemStack.method_7947() : 1);
    }

    public void setBestToolForBlock(class_2680 blockState) {
        int bestSlot = -1;
        float bestSpeed = 1.0f;
        for (int i = 0; i < 24; ++i) {
            class_1799 itemStack = this.method_5438(i);
            float speed = itemStack.method_7924(blockState);
            if (!(speed > bestSpeed)) continue;
            bestSpeed = speed;
            bestSlot = i;
        }
        if (bestSlot != -1) {
            this.setSelectedSlot(bestSlot);
        }
    }

    public class_1799 getBattery() {
        return this.method_5438(24);
    }

    public class_1799 getTask() {
        return this.method_5438(25);
    }

    public boolean canAddItem(class_1263 container) {
        for (int i = 0; i < 24; ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            for (int j = 0; j < container.method_5439(); ++j) {
                class_1799 conatinerStack = container.method_5438(j);
                if (!container.method_5437(j, stack) || !conatinerStack.method_7960() && (!class_1799.method_31577((class_1799)stack, (class_1799)conatinerStack) || conatinerStack.method_7947() >= conatinerStack.method_7914())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasItemsToDropOff() {
        for (int i = 0; i < 24; ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (stack.method_7960() || stack.method_7963()) continue;
            return true;
        }
        return false;
    }

    public void selectBestWeapon(class_1309 target) {
        float bestDamage = 1.0f;
        int bestSlot = this.selected;
        for (int i = 0; i < 24; ++i) {
            Optional<Float> optional;
            class_9285 itemAttributeModifiers;
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960() || (itemAttributeModifiers = (class_9285)itemStack.method_58694(class_9334.field_49636)) == null || !(optional = itemAttributeModifiers.comp_2393().stream().filter(attributeModifier -> attributeModifier.comp_2395().method_55838(class_5134.field_23721)).findFirst().map(attributeModifier -> Float.valueOf((float)attributeModifier.comp_2396().comp_2449()))).isPresent() || !(optional.get().floatValue() > bestDamage)) continue;
            bestDamage = optional.get().floatValue();
            bestSlot = i;
        }
        this.setSelectedSlot(bestSlot);
    }

    public List<ModuleItem> getEquippedModules() {
        class_1799 module2;
        class_1792 class_17922;
        ArrayList<ModuleItem> modules = new ArrayList<ModuleItem>();
        class_1799 module1 = this.method_5438(26);
        class_1792 class_17923 = module1.method_7909();
        if (class_17923 instanceof ModuleItem) {
            ModuleItem moduleItem = (ModuleItem)class_17923;
            modules.add(moduleItem);
        }
        if ((class_17922 = (module2 = this.method_5438(27)).method_7909()) instanceof ModuleItem) {
            ModuleItem moduleItem = (ModuleItem)class_17922;
            modules.add(moduleItem);
        }
        return modules;
    }

    static {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        int baseIndex = 28;
        map.put(class_1304.field_6166.method_32320(baseIndex), (Object)class_1304.field_6166);
        map.put(class_1304.field_6172.method_32320(baseIndex), (Object)class_1304.field_6172);
        map.put(class_1304.field_6174.method_32320(baseIndex), (Object)class_1304.field_6174);
        map.put(class_1304.field_6169.method_32320(baseIndex), (Object)class_1304.field_6169);
        EQUIPMENT_SLOT_MAPPING = map;
    }
}

