/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.farming;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.util.CropUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class FindFarmableBlock
extends class_4097<IRobotEntity> {
    public FindFarmableBlock() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()), (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 level, @NotNull IRobotEntity robot) {
        return robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.FARMING;
    }

    protected void start(@NotNull class_3218 level, @NotNull IRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        class_238 searchArea = OutlineRenderer.createBoundingBox(((class_4208)startPosOpt.get()).comp_2208(), ((class_4208)endPosOpt.get()).comp_2208());
        Optional<class_2338> matureCrop = this.findClosestMatureCrop(level, robot, searchArea);
        if (matureCrop.isPresent()) {
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get(), (Object)class_4208.method_19443((class_5321)level.method_27983(), (class_2338)matureCrop.get()));
            robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(matureCrop.get(), 0.5f, 1));
            return;
        }
        if (robot.hasModule(ModuleItem.ModuleType.CROP_REPLANT)) {
            this.findClosestEmptyFarmland(level, robot, searchArea).ifPresent(emptySpot -> {
                robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get(), (Object)class_4208.method_19443((class_5321)level.method_27983(), (class_2338)emptySpot));
                robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(emptySpot, 0.5f, 1));
            });
        }
    }

    private Optional<class_2338> findClosestMatureCrop(class_3218 level, IRobotEntity robot, class_238 searchArea) {
        return class_2338.method_29715((class_238)searchArea).map(class_2338::method_10062).filter(pos -> CropUtils.isFarmableCrop(level.method_8320(pos)) && CropUtils.isMature(level.method_8320(pos))).min(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)robot.method_24515())));
    }

    private Optional<class_2338> findClosestEmptyFarmland(class_3218 level, IRobotEntity robot, class_238 searchArea) {
        return class_2338.method_29715((class_238)searchArea).map(class_2338::method_10062).filter(pos -> level.method_8320(pos).method_26215() && this.isPlantableSpot(level, (class_2338)pos, robot)).min(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)robot.method_24515())));
    }

    private boolean isPlantableSpot(class_3218 level, class_2338 pos, IRobotEntity robot) {
        class_2680 ground = level.method_8320(pos.method_10074());
        if (!ground.method_27852(class_2246.field_10362) && !ground.method_27852(class_2246.field_10114)) {
            return false;
        }
        for (int i = 0; i < robot.getInventory().method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 stack = robot.getInventory().method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)class_17922;
            if (!CropUtils.isPlantable(stack.method_7909()) || !blockItem.method_7711().method_9564().method_26184((class_4538)level, pos)) continue;
            return true;
        }
        return false;
    }
}

