/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.farming;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.util.CropUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class FindNextCropToFarm
extends class_4097<IRobotEntity> {
    public FindNextCropToFarm() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()), (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 level, @NotNull IRobotEntity robot) {
        return robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.FARMING;
    }

    protected void start(@NotNull class_3218 level, @NotNull IRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        class_2338 startPos = ((class_4208)startPosOpt.get()).comp_2208();
        class_2338 endPos = ((class_4208)endPosOpt.get()).comp_2208();
        class_238 searchArea = OutlineRenderer.createBoundingBox(startPos, endPos);
        this.findClosestMatureCrop(level, robot, searchArea).ifPresent(cropPos -> {
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.FARM_TARGET_POS.get(), (Object)class_4208.method_19443((class_5321)level.method_27983(), (class_2338)cropPos));
            robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(cropPos, 0.5f, 1));
        });
    }

    private Optional<class_2338> findClosestMatureCrop(class_3218 level, IRobotEntity robot, class_238 searchArea) {
        class_2338 robotPos = robot.method_24515();
        return class_2338.method_29715((class_238)searchArea).map(class_2338::method_10062).filter(pos -> {
            class_2338 farmlandPos = pos.method_10074();
            return level.method_8320(farmlandPos).method_27852(class_2246.field_10362) && CropUtils.isFarmableCrop(level.method_8320(pos)) && CropUtils.isMature(level.method_8320(pos));
        }).min(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)robotPos)));
    }
}

