/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.woodcutting;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.util.TreeUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class FindNextTreeToCut
extends class_4097<IRobotEntity> {
    public FindNextTreeToCut() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()), (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 level, @NotNull IRobotEntity robot) {
        return robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.WOODCUTTING;
    }

    protected void start(@NotNull class_3218 level, @NotNull IRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        class_2338 startPos = ((class_4208)startPosOpt.get()).comp_2208();
        class_2338 endPos = ((class_4208)endPosOpt.get()).comp_2208();
        class_238 searchArea = OutlineRenderer.createBoundingBox(startPos, endPos);
        this.findClosestTree(level, robot, searchArea).ifPresent(treePos -> {
            class_2338 northPos = treePos.method_10095();
            class_2338 southPos = treePos.method_10072();
            class_2338 eastPos = treePos.method_10078();
            class_2338 westPos = treePos.method_10067();
            class_243 robotVec = robot.method_19538();
            class_2338 bestPos = northPos;
            double shortestDistance = northPos.method_19770((class_2374)robotVec);
            if (southPos.method_19770((class_2374)robotVec) < shortestDistance) {
                shortestDistance = southPos.method_19770((class_2374)robotVec);
                bestPos = southPos;
            }
            if (eastPos.method_19770((class_2374)robotVec) < shortestDistance) {
                shortestDistance = eastPos.method_19770((class_2374)robotVec);
                bestPos = eastPos;
            }
            if (westPos.method_19770((class_2374)robotVec) < shortestDistance) {
                bestPos = westPos;
            }
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get(), (Object)class_4208.method_19443((class_5321)level.method_27983(), (class_2338)treePos));
            robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(bestPos, 0.5f, 1));
            if (robot.hasModule(ModuleItem.ModuleType.REFORESTATION)) {
                class_2680 logState = level.method_8320(treePos);
                TreeUtils.getSaplingFromLog(logState).ifPresent(sapling -> {
                    robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get(), sapling);
                    robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.REPLANT_POS.get(), treePos);
                });
            }
        });
    }

    private Optional<class_2338> findClosestTree(class_3218 level, IRobotEntity robot, class_238 searchArea) {
        class_2338 robotPos = robot.method_24515();
        return class_2338.method_29715((class_238)searchArea).map(class_2338::method_10062).filter(pos -> this.isTreeLog(level, (class_2338)pos)).filter(pos -> TreeUtils.isTree(level, pos)).map(pos -> TreeUtils.getTreeBase(level, pos)).distinct().min(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)robotPos)));
    }

    private boolean isTreeLog(class_3218 level, class_2338 pos) {
        return level.method_8320(pos).method_26164(class_3481.field_15475);
    }
}

