/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.renderer;

import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.TaskMarkerItem;
import com.daqem.irobot.item.data.IRobotDataComponents;
import com.daqem.irobot.item.data.TaskMarkerDataComponent;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_746;
import net.minecraft.class_9331;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OutlineRenderer {
    public static void renderOutline(class_4587 poseStack) {
        class_4208 secondPos;
        class_1799 itemStack = OutlineRenderer.getValidTaskMarkerItem();
        if (itemStack == null) {
            return;
        }
        TaskMarkerDataComponent data = OutlineRenderer.getTaskMarkerData(itemStack);
        if (data == null) {
            return;
        }
        class_4208 firstPos = data.firstPos();
        if (!OutlineRenderer.isValidBox(firstPos, secondPos = data.secondPos())) {
            return;
        }
        OutlineRenderer.renderBoxOutline(poseStack, firstPos, secondPos);
    }

    private static class_1799 getValidTaskMarkerItem() {
        class_310 minecraft = class_310.method_1551();
        class_746 localPlayer = minecraft.field_1724;
        if (localPlayer == null) {
            return null;
        }
        class_1799 mainHand = localPlayer.method_6047();
        if (mainHand.method_7909() instanceof TaskMarkerItem || mainHand.method_7909() instanceof TaskItem) {
            return mainHand;
        }
        class_1799 offHand = localPlayer.method_6079();
        if (offHand.method_7909() instanceof TaskMarkerItem || mainHand.method_7909() instanceof TaskItem) {
            return offHand;
        }
        return null;
    }

    private static TaskMarkerDataComponent getTaskMarkerData(class_1799 itemStack) {
        class_9331 component = (class_9331)IRobotDataComponents.TASK_MARKER_DATA.get();
        if (!itemStack.method_57826(component)) {
            return null;
        }
        return (TaskMarkerDataComponent)itemStack.method_58694(component);
    }

    private static boolean isValidBox(class_4208 firstPos, class_4208 secondPos) {
        return firstPos != null && !firstPos.comp_2208().equals((Object)class_2338.field_10980) && secondPos != null && !secondPos.comp_2208().equals((Object)class_2338.field_10980) && firstPos.comp_2207().equals(secondPos.comp_2207());
    }

    private static void renderBoxOutline(class_4587 poseStack, class_4208 firstPos, class_4208 secondPos) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || !firstPos.comp_2207().equals(minecraft.field_1687.method_27983())) {
            return;
        }
        class_238 box = OutlineRenderer.createBoundingBox(firstPos.comp_2208(), secondPos.comp_2208());
        class_243 camera = minecraft.field_1773.method_19418().method_19326();
        poseStack.method_22903();
        class_4618 buffer = minecraft.method_22940().method_23003();
        class_4588 consumer = buffer.getBuffer(class_1921.method_49042());
        float inflate = box.method_1006(camera) ? -0.0078125f : 0.0078125f;
        box = box.method_997(camera.method_1021(-1.0));
        Vector3f minPos = new Vector3f((float)box.field_1323 - inflate, (float)box.field_1322 - inflate, (float)box.field_1321 - inflate);
        Vector3f maxPos = new Vector3f((float)box.field_1320 + inflate, (float)box.field_1325 + inflate, (float)box.field_1324 + inflate);
        OutlineRenderer.renderBoxEdges(poseStack, consumer, minPos, maxPos);
        buffer.method_23285();
        poseStack.method_22909();
    }

    public static class_238 createBoundingBox(class_2338 firstPos, class_2338 secondPos) {
        double minX = (double)Math.min(firstPos.method_10263(), secondPos.method_10263()) + 0.001;
        double minY = (double)Math.min(firstPos.method_10264(), secondPos.method_10264()) + 0.001;
        double minZ = (double)Math.min(firstPos.method_10260(), secondPos.method_10260()) + 0.001;
        double maxX = (double)(Math.max(firstPos.method_10263(), secondPos.method_10263()) + 1) - 0.001;
        double maxY = (double)(Math.max(firstPos.method_10264(), secondPos.method_10264()) + 1) - 0.001;
        double maxZ = (double)(Math.max(firstPos.method_10260(), secondPos.method_10260()) + 1) - 0.001;
        return new class_238(new class_243(minX, minY, minZ), new class_243(maxX, maxY, maxZ));
    }

    protected static void renderBoxEdges(class_4587 ms, class_4588 consumer, Vector3f minPos, Vector3f maxPos) {
        class_4587.class_4665 pose = ms.method_23760();
        float lenX = maxPos.x() - minPos.x();
        float lenY = maxPos.y() - minPos.y();
        float lenZ = maxPos.z() - minPos.z();
        class Edge {
            final float x;
            final float y;
            final float z;
            final float len;
            final class_2350 dir;

            Edge(float x, float y, float z, class_2350 dir, float len) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.dir = dir;
                this.len = len;
            }
        }
        List<Edge> edges = List.of(new Edge(minPos.x(), minPos.y(), minPos.z(), class_2350.field_11034, lenX), new Edge(minPos.x(), minPos.y(), minPos.z(), class_2350.field_11036, lenY), new Edge(minPos.x(), minPos.y(), minPos.z(), class_2350.field_11035, lenZ), new Edge(maxPos.x(), minPos.y(), minPos.z(), class_2350.field_11036, lenY), new Edge(maxPos.x(), minPos.y(), minPos.z(), class_2350.field_11035, lenZ), new Edge(minPos.x(), maxPos.y(), minPos.z(), class_2350.field_11034, lenX), new Edge(minPos.x(), maxPos.y(), minPos.z(), class_2350.field_11035, lenZ), new Edge(minPos.x(), minPos.y(), maxPos.z(), class_2350.field_11034, lenX), new Edge(minPos.x(), minPos.y(), maxPos.z(), class_2350.field_11036, lenY), new Edge(minPos.x(), maxPos.y(), maxPos.z(), class_2350.field_11034, lenX), new Edge(maxPos.x(), minPos.y(), maxPos.z(), class_2350.field_11036, lenY), new Edge(maxPos.x(), maxPos.y(), minPos.z(), class_2350.field_11035, lenZ));
        Vector3f origin = new Vector3f();
        for (Edge e : edges) {
            origin.set(e.x, e.y, e.z);
            OutlineRenderer.bufferCuboidLine(pose, consumer, origin, e.dir, e.len);
        }
    }

    public static void bufferCuboidLine(class_4587.class_4665 pose, class_4588 consumer, Vector3f origin, class_2350 direction, float length) {
        Vector3f minPos = new Vector3f();
        Vector3f maxPos = new Vector3f();
        float halfWidth = 0.03125f;
        minPos.set(origin.x() - halfWidth, origin.y() - halfWidth, origin.z() - halfWidth);
        maxPos.set(origin.x() + halfWidth, origin.y() + halfWidth, origin.z() + halfWidth);
        switch (direction) {
            case field_11033: {
                minPos.add(0.0f, -length, 0.0f);
                break;
            }
            case field_11036: {
                maxPos.add(0.0f, length, 0.0f);
                break;
            }
            case field_11043: {
                minPos.add(0.0f, 0.0f, -length);
                break;
            }
            case field_11035: {
                maxPos.add(0.0f, 0.0f, length);
                break;
            }
            case field_11039: {
                minPos.add(-length, 0.0f, 0.0f);
                break;
            }
            case field_11034: {
                maxPos.add(length, 0.0f, 0.0f);
            }
        }
        OutlineRenderer.bufferCuboid(pose, consumer, minPos, maxPos);
    }

    public static void bufferCuboid(class_4587.class_4665 pose, class_4588 consumer, Vector3f minPos, Vector3f maxPos) {
        Matrix4f posMatrix = pose.method_23761();
        Matrix3f normalMatrix = pose.method_23762();
        Vector3f[] corners = new Vector3f[]{new Vector3f(minPos.x(), minPos.y(), maxPos.z()), new Vector3f(minPos.x(), minPos.y(), minPos.z()), new Vector3f(maxPos.x(), minPos.y(), minPos.z()), new Vector3f(maxPos.x(), minPos.y(), maxPos.z()), new Vector3f(minPos.x(), maxPos.y(), minPos.z()), new Vector3f(minPos.x(), maxPos.y(), maxPos.z()), new Vector3f(maxPos.x(), maxPos.y(), maxPos.z()), new Vector3f(maxPos.x(), maxPos.y(), minPos.z())};
        Vector4f temp = new Vector4f();
        float[][] worldCorners = new float[corners.length][3];
        for (int i = 0; i < corners.length; ++i) {
            temp.set(corners[i].x(), corners[i].y(), corners[i].z(), 1.0f);
            temp.mul((Matrix4fc)posMatrix);
            worldCorners[i][0] = temp.x();
            worldCorners[i][1] = temp.y();
            worldCorners[i][2] = temp.z();
        }
        int[][] faces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {7, 2, 1, 4}, {5, 0, 3, 6}, {4, 1, 0, 5}, {6, 3, 2, 7}};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
        float[][] uvs = new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}};
        Vector3f normalTemp = new Vector3f();
        for (int f = 0; f < faces.length; ++f) {
            normalTemp.set((Vector3fc)normals[f]);
            normalTemp.mul((Matrix3fc)normalMatrix);
            float nx = normalTemp.x();
            float ny = normalTemp.y();
            float nz = normalTemp.z();
            for (int v = 0; v < 4; ++v) {
                int idx = faces[f][v];
                float[] pos = worldCorners[idx];
                float[] uv = uvs[v];
                consumer.method_22912(pos[0], pos[1], pos[2]).method_1336(64, 229, 242, 255).method_22913(uv[0], uv[1]).method_22922(class_4608.field_21444).method_60803(1).method_22914(nx, ny, nz);
            }
        }
    }
}

