/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.InteractableRobot;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.RobotEquipment;
import com.daqem.irobot.entity.RobotInventory;
import com.daqem.irobot.entity.ai.IRobotActivities;
import com.daqem.irobot.entity.ai.IRobotBrain;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.ai.RobotBrainPackages;
import com.daqem.irobot.item.data.BatteryDataComponent;
import com.daqem.irobot.item.data.IRobotDataComponents;
import com.daqem.irobot.item.data.TaskDataComponent;
import com.daqem.irobot.item.data.TaskMarkerDataComponent;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.menu.RobotMenu;
import com.daqem.irobot.stats.IRobotStats;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Dynamic;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_10583;
import net.minecraft.class_10599;
import net.minecraft.class_10630;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5630;
import net.minecraft.class_6880;
import net.minecraft.class_747;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class IRobotEntity
extends class_1321
implements GeoEntity,
InteractableRobot {
    private static final class_2940<Boolean> IS_MINING = class_2945.method_12791(IRobotEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_FARMING = class_2945.method_12791(IRobotEntity.class, (class_2941)class_2943.field_13323);
    private static final int REGENERATION_COOLDOWN_TICKS = 20;
    private static final double REGENERATION_ENERGY_COST = 10.0;
    private static final float REGENERATION_AMOUNT = 1.0f;
    private static final EnumMap<ModuleItem.ModuleType, class_2960> ATTRIBUTE_MODIFIER_LOCATIONS = new EnumMap(ModuleItem.ModuleType.class);
    protected final RobotInventory inventory;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> IRobotEntity.this.getEntityId();
                case 1 -> class_3532.method_15357((double)IRobotEntity.this.getEnergy());
                case 2 -> class_3532.method_15357((double)IRobotEntity.this.getMaxEnergy());
                case 3 -> IRobotEntity.this.getActiveActivityIndex();
                case 4 -> class_3532.method_15375((float)IRobotEntity.this.method_6032());
                case 5 -> class_3532.method_15375((float)IRobotEntity.this.method_6063());
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 6;
        }
    };
    private int regenerationCooldown = 0;
    @Nullable
    private class_1657 interactingPlayer;
    private class_243 lastPos;
    private double distanceSqAccumulator;

    protected IRobotEntity(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.inventory = new RobotInventory(this, this.field_56535);
        this.method_5942().method_70687(true);
        this.method_5942().method_6354(true);
        this.method_5942().method_61439(48.0f);
        this.method_5952(true);
        this.lastPos = this.method_19538();
    }

    public static class_4168 getActivityByIndex(int index) {
        return switch (index) {
            case 0 -> class_4168.field_18595;
            case 1 -> class_4168.field_18597;
            case 2 -> (class_4168)IRobotActivities.PROTECT.get();
            case 3 -> (class_4168)IRobotActivities.MINE.get();
            case 4 -> (class_4168)IRobotActivities.CUT_WOOD.get();
            case 5 -> (class_4168)IRobotActivities.FARM.get();
            case 6 -> (class_4168)IRobotActivities.FOLLOW.get();
            case 7 -> (class_4168)IRobotActivities.RECHARGE.get();
            case 8 -> (class_4168)IRobotActivities.DROPOFF.get();
            default -> class_4168.field_18595;
        };
    }

    public static int getIndexByActivity(class_4168 activity) {
        if (activity == class_4168.field_18595) {
            return 0;
        }
        if (activity == class_4168.field_18597) {
            return 1;
        }
        if (activity == IRobotActivities.PROTECT.get()) {
            return 2;
        }
        if (activity == IRobotActivities.MINE.get()) {
            return 3;
        }
        if (activity == IRobotActivities.CUT_WOOD.get()) {
            return 4;
        }
        if (activity == IRobotActivities.FARM.get()) {
            return 5;
        }
        if (activity == IRobotActivities.FOLLOW.get()) {
            return 6;
        }
        if (activity == IRobotActivities.RECHARGE.get()) {
            return 7;
        }
        if (activity == IRobotActivities.DROPOFF.get()) {
            return 8;
        }
        return 0;
    }

    public static class_5132.class_5133 createRobotAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_49076, 1.0).method_26868(class_5134.field_51581, 0.0).method_26868(class_5134.field_51576, 0.2).method_26868(class_5134.field_23721, 4.0);
    }

    public int getActiveActivityIndex() {
        return this.method_18868().method_24538().map(IRobotEntity::getIndexByActivity).orElse(0);
    }

    public abstract int getRechargeThreshold();

    protected abstract class_1269 handleItemInteraction(class_3222 var1, class_1799 var2, class_1268 var3);

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_MINING, (Object)false);
        builder.method_56912(IS_FARMING, (Object)false);
    }

    public boolean isMining() {
        return (Boolean)this.field_6011.method_12789(IS_MINING);
    }

    public void setMining(boolean mining) {
        this.field_6011.method_12778(IS_MINING, (Object)mining);
    }

    public boolean isFarming() {
        return (Boolean)this.field_6011.method_12789(IS_FARMING);
    }

    public void setFarming(boolean farming) {
        this.field_6011.method_12778(IS_FARMING, (Object)farming);
    }

    @NotNull
    public class_4095<IRobotEntity> method_18868() {
        class_4095 brain = super.method_18868();
        if (brain instanceof IRobotBrain) {
            IRobotBrain robotBrain = (IRobotBrain)brain;
            robotBrain.irobot$setRobot(this);
        }
        return brain;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_4095.class_5303<MiniRobotEntity> method_28306() {
        return RobotBrainPackages.createBrainProvider();
    }

    @NotNull
    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        class_4095 brain = this.method_28306().method_28335(dynamic);
        RobotBrainPackages.registerBrainGoals((class_4095<MiniRobotEntity>)brain);
        return brain;
    }

    public void method_6007() {
        double distSq;
        super.method_6007();
        if (!this.method_37908().field_9236 && this.lastPos != class_243.field_1353 && (distSq = this.method_19538().method_1025(this.lastPos)) > 0.0) {
            this.distanceSqAccumulator += distSq;
        }
        this.lastPos = this.method_19538();
        this.recalculateAttributes();
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("robotBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("robotInventory");
        this.inventory.tick();
        profiler.method_15407();
        if (this.method_5805()) {
            if (this.field_6012 % 20 == 0) {
                double energyCost = this.distanceSqAccumulator / 16.0;
                if (energyCost > 0.0) {
                    this.setEnergy(this.getEnergy() - energyCost * this.getEnergyConsumptionModifier());
                }
                this.distanceSqAccumulator = 0.0;
            }
            this.handleHealthRegeneration();
            this.handleSolarCharging();
        }
        super.method_5958(level);
    }

    private void handleHealthRegeneration() {
        if (this.method_6032() < this.method_6063() && this.getEnergy() >= 10.0) {
            if (this.regenerationCooldown > 0) {
                --this.regenerationCooldown;
            } else {
                this.method_6025(1.0f);
                this.setEnergy(this.getEnergy() - 10.0 * this.getEnergyConsumptionModifier());
                this.regenerationCooldown = 20;
            }
        }
    }

    private void handleSolarCharging() {
        if (this.hasModule(ModuleItem.ModuleType.SOLAR_PANEL) && this.isDay() && this.method_37908().method_8311(this.method_24515()) && this.field_6012 % 20 == 0) {
            double energyToGen = 2.0;
            this.setEnergy(this.getEnergy() + energyToGen);
        }
    }

    private boolean isDay() {
        int i = this.method_37908().method_8314(class_1944.field_9284, this.method_24515()) - this.method_37908().method_8594();
        float f = this.method_37908().method_8442(1.0f);
        float g = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
        f += (g - f) * 0.2f;
        i = Math.round((float)i * class_3532.method_15362((float)f));
        i = class_3532.method_15340((int)i, (int)0, (int)15);
        return i >= 8;
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        class_1297 attacker;
        boolean wasHurt = super.method_64397(level, damageSource, amount);
        if (wasHurt && !this.method_37908().method_8608() && (attacker = damageSource.method_5529()) instanceof class_1309) {
            class_1309 livingAttacker = (class_1309)attacker;
            if (attacker instanceof class_1657) {
                return true;
            }
            this.method_18868().method_18878(class_4140.field_22355, (Object)livingAttacker);
        }
        return wasHurt;
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_10583 ownerReference = this.method_66287();
            if (ownerReference == null) {
                return class_1269.field_5811;
            }
            if (!ownerReference.method_66256((class_10599)player)) {
                serverPlayer.method_43502((class_2561)IRobot.translatable("error.robot.not_owner").method_27692(class_124.field_1061), true);
                return class_1269.field_21466;
            }
            class_1799 itemInHand = player.method_5998(hand);
            class_1269 itemResult = this.handleItemInteraction(serverPlayer, itemInHand, hand);
            if (itemResult.method_23665()) {
                return itemResult;
            }
            if (hand == class_1268.field_5808) {
                player.method_7281((class_2960)IRobotStats.TALKED_TO_ROBOT.get());
            }
            this.startInteracting(serverPlayer);
        }
        return class_1269.field_5812;
    }

    public void method_6078(class_1282 damageSource) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.STATION_POS.get()).ifPresent(globalPos -> serverLevel.method_19494().method_19129(globalPos.comp_2208()));
        }
        super.method_6078(damageSource);
    }

    protected void method_5652(class_11372 output) {
        super.method_5652(output);
        this.inventory.save((class_11372.class_11373<class_11343>)output.method_71467("Inventory", class_11343.field_60354));
    }

    protected void method_5749(class_11368 input) {
        super.method_5749(input);
        this.inventory.load((class_11368.class_11369<class_11343>)input.method_71437("Inventory", class_11343.field_60354));
        if (this.method_37908() instanceof class_3218) {
            this.recalculateAttributes();
        }
    }

    private void startInteracting(class_3222 serverPlayer) {
        this.setInteractingPlayer((class_1657)serverPlayer);
        this.openScreen(serverPlayer, this.method_5476());
    }

    private void openScreen(class_3222 serverPlayer, class_2561 title) {
        serverPlayer.method_17355((class_3908)new class_747((containerId, playerInventory, player) -> new RobotMenu(containerId, playerInventory, this), title));
    }

    @Override
    public class_3913 getContainerData() {
        return this.containerData;
    }

    @Override
    @Nullable
    public class_1657 getInteractingPlayer() {
        return this.interactingPlayer;
    }

    @Override
    public void setInteractingPlayer(@Nullable class_1657 player) {
        this.interactingPlayer = player;
    }

    @Override
    public boolean stillValid(class_1657 player) {
        return this.getInteractingPlayer() == player && this.method_5805() && this.method_5858((class_1297)player) < 64.0;
    }

    @Override
    public int getEntityId() {
        return this.method_5628();
    }

    @Override
    public RobotInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public class_5630 method_32318(int slot) {
        int i = slot - 300;
        return i >= 0 && i < this.inventory.method_5439() ? class_5630.method_32328((class_1263)this.inventory, (int)i) : super.method_32318(slot);
    }

    protected void method_5949(class_3218 level, class_1542 entity) {
        this.inventory.pickUpItem(level, entity);
    }

    public boolean method_20820(class_3218 level, class_1799 stack) {
        return this.inventory.canAddItem(stack);
    }

    protected void method_16078(class_3218 level) {
        this.destroyVanishingCursedItems();
        this.inventory.dropAll();
    }

    protected void destroyVanishingCursedItems() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960() || !class_1890.method_60142((class_1799)itemStack, (class_9331)class_9701.field_51655)) continue;
            this.inventory.method_5441(i);
        }
    }

    public void method_6105(class_1282 damageSource, float damageAmount) {
        this.method_57292(damageSource, damageAmount, new class_1304[]{class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169});
    }

    public void method_36977(class_1282 damageSource, float damageAmount) {
        this.method_57292(damageSource, damageAmount, new class_1304[]{class_1304.field_6169});
    }

    @NotNull
    protected class_10630 method_67518() {
        return new RobotEquipment(this);
    }

    public float getDestroySpeed(class_2680 state) {
        float f = this.inventory.getSelectedItem().method_7924(state);
        if (f > 1.0f) {
            f += (float)this.method_45325(class_5134.field_51581);
        }
        if (class_1292.method_5576((class_1309)this)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)this) + 1) * 0.2f;
        }
        if (this.method_6059(class_1294.field_5901)) {
            float g = switch (this.method_6112(class_1294.field_5901).method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= g;
        }
        f *= (float)this.method_45325(class_5134.field_49076);
        if (this.method_5777(class_3486.field_15517)) {
            f *= (float)this.method_5996(class_5134.field_51576).method_6194();
        }
        if (!this.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean hasCorrectToolForDrops(class_2680 state) {
        return !state.method_29291() || this.inventory.getSelectedItem().method_7951(state);
    }

    public void setBestToolForBlock(class_2680 blockState) {
        this.getInventory().setBestToolForBlock(blockState);
    }

    public double getEnergy() {
        class_1799 battery = this.inventory.getBattery();
        if (battery.method_7960()) {
            return 0.0;
        }
        BatteryDataComponent data = (BatteryDataComponent)battery.method_58694((class_9331)IRobotDataComponents.BATTERY_DATA.get());
        return data != null ? data.energy() : 0.0;
    }

    public void setEnergy(double energy) {
        BatteryDataComponent data;
        class_1799 battery = this.inventory.getBattery();
        if (!battery.method_7960() && (data = (BatteryDataComponent)battery.method_58694((class_9331)IRobotDataComponents.BATTERY_DATA.get())) != null) {
            battery.method_57379((class_9331)IRobotDataComponents.BATTERY_DATA.get(), (Object)data.withEnergy(energy));
        }
    }

    public double getMaxEnergy() {
        class_1799 battery = this.inventory.getBattery();
        if (battery.method_7960()) {
            return 0.0;
        }
        BatteryDataComponent data = (BatteryDataComponent)battery.method_58694((class_9331)IRobotDataComponents.BATTERY_DATA.get());
        return data != null ? data.maxEnergy() : 0.0;
    }

    public void recalculateAttributes() {
        ImmutableMultimap.Builder allPossibleModifiersBuilder = ImmutableMultimap.builder();
        for (ModuleItem.ModuleType type : ATTRIBUTE_MODIFIER_LOCATIONS.keySet()) {
            double amount = this.getModuleValue(type);
            class_1322.class_1323 operation = this.getModuleOperation(type);
            class_2960 id = ATTRIBUTE_MODIFIER_LOCATIONS.get((Object)type);
            class_1322 modifier = new class_1322(id, amount, operation);
            switch (type) {
                case SPEED_BOOST: {
                    allPossibleModifiersBuilder.put((Object)class_5134.field_23719, (Object)modifier);
                    break;
                }
                case MINING_SPEED: {
                    allPossibleModifiersBuilder.put((Object)class_5134.field_51581, (Object)modifier);
                    break;
                }
                case ATTACK_DAMAGE: {
                    allPossibleModifiersBuilder.put((Object)class_5134.field_23721, (Object)modifier);
                    break;
                }
                case DURABILITY: {
                    allPossibleModifiersBuilder.put((Object)class_5134.field_23716, (Object)modifier);
                }
            }
        }
        this.method_6127().method_59935((Multimap)allPossibleModifiersBuilder.build());
        this.method_6127().method_59932(this.createCurrentAttributeMap());
        if (this.method_6032() > this.method_6063()) {
            this.method_6033(this.method_6063());
        }
    }

    private Multimap<class_6880<class_1320>, class_1322> createCurrentAttributeMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (ModuleItem module : this.inventory.getEquippedModules()) {
            double amount = this.getModuleValue(module.getType());
            class_1322.class_1323 operation = this.getModuleOperation(module.getType());
            class_2960 id = ATTRIBUTE_MODIFIER_LOCATIONS.get((Object)module.getType());
            if (id == null) continue;
            class_1322 modifier = new class_1322(id, amount, operation);
            switch (module.getType()) {
                case SPEED_BOOST: {
                    builder.put((Object)class_5134.field_23719, (Object)modifier);
                    break;
                }
                case MINING_SPEED: {
                    builder.put((Object)class_5134.field_51581, (Object)modifier);
                    break;
                }
                case ATTACK_DAMAGE: {
                    builder.put((Object)class_5134.field_23721, (Object)modifier);
                    break;
                }
                case DURABILITY: {
                    builder.put((Object)class_5134.field_23716, (Object)modifier);
                }
            }
        }
        return builder.build();
    }

    private double getModuleValue(ModuleItem.ModuleType type) {
        return switch (type) {
            case ModuleItem.ModuleType.SPEED_BOOST -> 0.5;
            case ModuleItem.ModuleType.MINING_SPEED -> 2.0;
            case ModuleItem.ModuleType.ATTACK_DAMAGE -> 4.0;
            case ModuleItem.ModuleType.DURABILITY -> 20.0;
            default -> 0.0;
        };
    }

    private class_1322.class_1323 getModuleOperation(ModuleItem.ModuleType type) {
        if (type == ModuleItem.ModuleType.SPEED_BOOST) {
            return class_1322.class_1323.field_6330;
        }
        return class_1322.class_1323.field_6328;
    }

    public boolean hasModule(ModuleItem.ModuleType type) {
        return this.inventory.getEquippedModules().stream().anyMatch(m -> m.getType() == type);
    }

    public double getEnergyConsumptionModifier() {
        if (this.hasModule(ModuleItem.ModuleType.BATTERY_EFFICIENCY)) {
            return 0.75;
        }
        return 1.0;
    }

    public boolean needsRecharging() {
        return this.getEnergy() < (double)this.getRechargeThreshold();
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        return null;
    }

    public boolean needsToDropOff() {
        return this.inventory.isMainInventoryFull();
    }

    public boolean hasTaskItem() {
        class_1799 task = this.getInventory().getTask();
        return task != null && !task.method_7960();
    }

    @Nullable
    public TaskDataComponent getTaskItemData() {
        class_1799 task = this.getInventory().getTask();
        if (task != null && !task.method_7960() && task.method_57826((class_9331)IRobotDataComponents.TASK_DATA.get())) {
            return (TaskDataComponent)task.method_58694((class_9331)IRobotDataComponents.TASK_DATA.get());
        }
        return null;
    }

    public TaskMarkerDataComponent getTaskMarkerData() {
        class_1799 task = this.getInventory().getTask();
        if (task != null && !task.method_7960() && task.method_57826((class_9331)IRobotDataComponents.TASK_MARKER_DATA.get())) {
            return (TaskMarkerDataComponent)task.method_58694((class_9331)IRobotDataComponents.TASK_MARKER_DATA.get());
        }
        return null;
    }

    public List<class_1542> getItemEntitiesAround() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            TaskMarkerDataComponent taskMarkerData;
            class_3218 serverLevel = (class_3218)class_19372;
            class_238 searchArea = this.method_5829().method_1009(16.0, 3.0, 16.0);
            if (this.hasTaskItem() && (taskMarkerData = this.getTaskMarkerData()) != null && this.method_37908().method_27983().equals(taskMarkerData.firstPos().comp_2207())) {
                searchArea = OutlineRenderer.createBoundingBox(taskMarkerData.firstPos().comp_2208(), taskMarkerData.secondPos().comp_2208()).method_1014(2.0);
            }
            return serverLevel.method_18467(class_1542.class, searchArea);
        }
        return List.of();
    }

    public boolean hasItemsAround() {
        return this.getItemEntitiesAround().stream().anyMatch(class_1297::method_5805);
    }

    public class_1542 getNearestItemEntity() {
        List<class_1542> items = this.getItemEntitiesAround();
        class_1542 nearestItem = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (class_1542 item : items) {
            double distanceSq;
            if (!item.method_5805() || this.method_37908().method_8320(item.method_24515().method_10074()).method_26215() || !((distanceSq = this.method_5858((class_1297)item)) < nearestDistanceSq)) continue;
            nearestDistanceSq = distanceSq;
            nearestItem = item;
        }
        return nearestItem;
    }

    public boolean isCharging() {
        return this.method_18868().method_24538().orElse(class_4168.field_18595).equals(IRobotActivities.RECHARGE.get());
    }

    public boolean isDroppingOffItems() {
        return this.method_18868().method_24538().orElse(class_4168.field_18595).equals(IRobotActivities.DROPOFF.get());
    }

    public boolean isFollowing() {
        return this.method_18868().method_24538().orElse(class_4168.field_18595).equals(IRobotActivities.FOLLOW.get());
    }

    static {
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.SPEED_BOOST, IRobot.getId("speed_boost_module"));
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.MINING_SPEED, IRobot.getId("mining_speed_module"));
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.ATTACK_DAMAGE, IRobot.getId("attack_damage_module"));
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.DURABILITY, IRobot.getId("durability_module"));
    }
}

