/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.mining;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public class FindNextBlockToMine
extends class_4097<MiniRobotEntity> {
    private static final int SCAN_STEP_SIZE = 1;
    private static final int LANE_WIDTH = 3;

    public FindNextBlockToMine() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get()), (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(class_3218 level, MiniRobotEntity robot) {
        return robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.MINING;
    }

    protected void start(class_3218 level, MiniRobotEntity robot, long gameTime) {
        Optional<class_2338> nearestBlock;
        class_243 closestPoint;
        Optional startPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        class_238 miningArea = OutlineRenderer.createBoundingBox(((class_4208)startPosOpt.get()).comp_2208(), ((class_4208)endPosOpt.get()).comp_2208());
        if (!miningArea.method_1014(1.0).method_1006(robot.method_19538()) && !level.method_8320(class_2338.method_49638((class_2374)(closestPoint = this.getClosestPointInAABB(robot.method_19538(), miningArea))).method_10074()).method_26215()) {
            robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(closestPoint, 0.5f, 0));
            return;
        }
        class_2350 miningDir = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.MINING_DIRECTION.get()).orElse(class_2350.field_11034);
        if (!robot.method_18868().method_18896((class_4140)IRobotMemoryModuleTypes.MINING_DIRECTION.get())) {
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.MINING_DIRECTION.get(), (Object)miningDir);
        }
        if (!robot.method_18868().method_18896((class_4140)IRobotMemoryModuleTypes.LANE_DIRECTION.get())) {
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.LANE_DIRECTION.get(), (Object)miningDir.method_10170());
        }
        if ((nearestBlock = this.findNearestBlock(level, robot, miningArea)).isPresent()) {
            class_2338 targetPos = nearestBlock.get();
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get(), (Object)class_4208.method_19443((class_5321)level.method_27983(), (class_2338)targetPos));
            robot.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(targetPos));
            if (!robot.method_24515().method_19771((class_2382)targetPos, 2.0)) {
                robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(targetPos, 0.5f, 2));
            }
        } else {
            this.findNextMiningFace(level, robot, miningArea, gameTime);
        }
    }

    private Optional<class_2338> findNearestBlock(class_3218 level, MiniRobotEntity robot, class_238 miningArea) {
        class_2338 robotBlockPos = robot.method_24515();
        class_238 aroundRobot = new class_238(robotBlockPos).method_1009(3.0, 2.0, 3.0);
        class_238 searchBox = aroundRobot.method_999(miningArea);
        HashMap<Integer, List> positions = new HashMap<Integer, List>();
        for (int y = class_3532.method_15357((double)searchBox.field_1322); y <= class_3532.method_15357((double)searchBox.field_1325); ++y) {
            for (int x = class_3532.method_15357((double)searchBox.field_1323); x <= class_3532.method_15357((double)searchBox.field_1320); ++x) {
                for (int z = class_3532.method_15357((double)searchBox.field_1321); z <= class_3532.method_15357((double)searchBox.field_1324); ++z) {
                    positions.computeIfAbsent(y, k -> new ArrayList()).add(new class_2338(x, y, z));
                }
            }
        }
        positions.values().forEach(list -> list.sort(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)robotBlockPos))));
        for (Integer y : positions.keySet().stream().sorted(Comparator.reverseOrder()).toList()) {
            for (class_2338 pos : (List)positions.get(y)) {
                if (level.method_8320(pos).method_26215() || level.method_31606(pos)) continue;
                return Optional.of(pos);
            }
        }
        return Optional.empty();
    }

    private void findNextMiningFace(class_3218 level, MiniRobotEntity robot, class_238 miningArea, long gameTime) {
        class_2350 miningDir = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.MINING_DIRECTION.get()).orElse(class_2350.field_11034);
        class_2338 robotPos = robot.method_24515();
        for (int i = 0; i < (int)Math.max(miningArea.method_17939(), miningArea.method_17941()); ++i) {
            class_2338 scanPos = robotPos.method_10079(miningDir, i);
            Optional<class_2338> target = this.findWalkablePosNear(level, scanPos, miningArea);
            if (!target.isPresent()) continue;
            robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(target.get(), 0.5f, 0));
            return;
        }
        Optional laneDirOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.LANE_DIRECTION.get());
        if (laneDirOpt.isEmpty()) {
            this.finishMiningTask(robot);
            return;
        }
        class_2350 laneDir = (class_2350)laneDirOpt.get();
        class_2338 nextLanePos = robotPos.method_10079(laneDir, 3);
        if (miningArea.method_1006(class_243.method_24953((class_2382)nextLanePos))) {
            class_2350 newMiningDir = miningDir.method_10153();
            robot.method_18868().method_18878((class_4140)IRobotMemoryModuleTypes.MINING_DIRECTION.get(), (Object)newMiningDir);
            robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(nextLanePos, 0.5f, 0));
        } else {
            this.lastResortSearch(level, robot, miningArea);
        }
    }

    private Optional<class_2338> findWalkablePosNear(class_3218 level, class_2338 targetPos, class_238 miningArea) {
        for (int y = class_3532.method_15357((double)miningArea.field_1325); y >= class_3532.method_15357((double)miningArea.field_1322); --y) {
            class_2338 currentPos = new class_2338(targetPos.method_10263(), y, targetPos.method_10260());
            if (!miningArea.method_1006(class_243.method_24953((class_2382)currentPos)) || level.method_8320(currentPos).method_26215()) continue;
            class_2338 groundPos = currentPos.method_10074();
            while (groundPos.method_10264() >= class_3532.method_15357((double)miningArea.field_1322)) {
                if (level.method_8320(groundPos).method_26216() && level.method_8320(groundPos.method_10084()).method_26215()) {
                    return Optional.of(groundPos.method_10084());
                }
                groundPos = groundPos.method_10074();
            }
        }
        return Optional.empty();
    }

    private void lastResortSearch(class_3218 level, MiniRobotEntity robot, class_238 miningArea) {
        class_2338 robotPos = robot.method_24515();
        class_238 searchBox = new class_238(robotPos).method_1009(50.0, 5.0, 50.0).method_999(miningArea);
        class_1408 navigator = robot.method_5942();
        for (int y = class_3532.method_15357((double)searchBox.field_1325); y >= class_3532.method_15357((double)searchBox.field_1322); --y) {
            for (int x = class_3532.method_15357((double)searchBox.field_1323); x <= class_3532.method_15357((double)searchBox.field_1320); ++x) {
                for (int z = class_3532.method_15357((double)searchBox.field_1321); z <= class_3532.method_15357((double)searchBox.field_1324); ++z) {
                    class_11 path;
                    class_2338 walkToTarget;
                    class_2338 potentialTarget = new class_2338(x, y, z);
                    if (level.method_8320(potentialTarget).method_26215() || !level.method_8320(walkToTarget = potentialTarget.method_10084()).method_26215() || (path = navigator.method_6348(walkToTarget, 1)) == null || !path.method_21655()) continue;
                    robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(walkToTarget, 0.5f, 0));
                    return;
                }
            }
        }
        this.finishMiningTask(robot);
    }

    private void finishMiningTask(MiniRobotEntity robot) {
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.ASSIGNED_TASK.get());
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.MINING_DIRECTION.get());
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.LANE_DIRECTION.get());
        robot.method_18868().method_24526(class_4168.field_18595);
    }

    private class_243 getClosestPointInAABB(class_243 point, class_238 box) {
        double x = class_3532.method_15350((double)point.field_1352, (double)box.field_1323, (double)box.field_1320);
        double y = class_3532.method_15350((double)point.field_1351, (double)box.field_1322, (double)box.field_1325);
        double z = class_3532.method_15350((double)point.field_1350, (double)box.field_1321, (double)box.field_1324);
        return new class_243(x, y, z);
    }
}

