/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.woodcutting;

import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.util.TreeUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;

public class CutDownTree
extends class_4097<MiniRobotEntity> {
    private static final double MAX_REACH_DISTANCE_SQ = 12.25;
    private static final double PREFERRED_REACH_DISTANCE_SQ = 6.25;
    private int ticksSinceStarted;
    private int totalTicksToCut;
    private class_2338 targetPos;
    private int retryCounter = 0;

    public CutDownTree() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()), (Object)class_4141.field_18456));
    }

    protected boolean method_18915(long gameTime) {
        return this.ticksSinceStarted > 6000;
    }

    protected void start(class_3218 level, MiniRobotEntity robot, long gameTime) {
        this.ticksSinceStarted = 0;
        this.retryCounter = 0;
        robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()).ifPresent(globalPos -> {
            this.targetPos = globalPos.comp_2208();
            robot.setMining(true);
            robot.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetPos));
            class_2680 blockState = level.method_8320(this.targetPos);
            robot.setBestToolForBlock(blockState);
            Set<class_2338> treeBlocks = TreeUtils.getTreeBlocks(level, this.targetPos);
            float destroySpeed = robot.getDestroySpeed(blockState);
            float blockHardness = blockState.method_26214((class_1922)level, this.targetPos);
            if (blockHardness <= 0.0f) {
                this.totalTicksToCut = treeBlocks.isEmpty() ? 20 : treeBlocks.size();
            } else {
                int i = robot.hasCorrectToolForDrops(blockState) ? 30 : 100;
                float ticksPerBlock = blockHardness * (float)i / destroySpeed;
                this.totalTicksToCut = (int)((float)treeBlocks.size() * ticksPerBlock);
            }
        });
    }

    protected void stop(class_3218 level, MiniRobotEntity robot, long gameTime) {
        robot.setMining(false);
        if (this.targetPos != null) {
            level.method_8517(robot.method_5628(), this.targetPos, -1);
        }
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get());
        robot.method_18868().method_18875(class_4140.field_18446);
        this.targetPos = null;
    }

    protected void tick(class_3218 level, MiniRobotEntity robot, long gameTime) {
        Optional treePosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get());
        if (treePosOpt.isEmpty() || !((class_4208)treePosOpt.get()).comp_2208().equals((Object)this.targetPos)) {
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        double distanceSq = robot.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPos));
        if (distanceSq > 12.25) {
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        if (distanceSq > 6.25) {
            if (this.retryCounter < 5) {
                robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, 0.5f, 1));
                ++this.retryCounter;
                return;
            }
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        robot.method_18868().method_18875(class_4140.field_18445);
        ++this.ticksSinceStarted;
        if (this.totalTicksToCut > 0) {
            int progress = (int)((float)this.ticksSinceStarted / (float)this.totalTicksToCut * 10.0f);
            level.method_8517(robot.method_5628(), this.targetPos, progress);
        }
        if (this.ticksSinceStarted >= this.totalTicksToCut) {
            Set<class_2338> treeBlocks = TreeUtils.getTreeBlocks(level, this.targetPos);
            class_2680 logState = level.method_8320(this.targetPos);
            boolean canHarvest = robot.hasCorrectToolForDrops(logState);
            for (class_2338 pos : treeBlocks) {
                level.method_8651(pos, canHarvest, (class_1297)robot);
            }
            robot.setEnergy(robot.getEnergy() - (double)treeBlocks.size() * 2.0);
            this.method_18925(level, (class_1309)robot, gameTime);
        }
    }

    protected boolean canStillUse(class_3218 level, MiniRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            return false;
        }
        Optional treePos = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get());
        if (treePos.isEmpty() || !((class_4208)treePos.get()).comp_2208().equals((Object)this.targetPos)) {
            return false;
        }
        if (!level.method_8320(this.targetPos).method_26164(class_3481.field_15475)) {
            return false;
        }
        return robot.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPos)) <= 12.25;
    }
}

