/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.woodcutting;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class ReplantTree
extends Behavior<MiniRobotEntity> {
    public ReplantTree() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.REPLANT_POS.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, MiniRobotEntity robot) {
        return robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()).isEmpty();
    }

    protected void start(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        Optional replantPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.REPLANT_POS.get());
        Optional saplingItemOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get());
        if (replantPosOpt.isPresent() && saplingItemOpt.isPresent()) {
            BlockPos replantPos = (BlockPos)replantPosOpt.get();
            Item saplingItem = (Item)saplingItemOpt.get();
            if (!robot.getInventory().contains(saplingItem.getDefaultInstance())) {
                this.doStop(level, (LivingEntity)robot, gameTime);
                return;
            }
            if (!replantPos.closerThan((Vec3i)robot.blockPosition(), 3.0)) {
                robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(replantPos, 0.5f, 1));
                return;
            }
            if (this.tryReplant(level, robot, replantPos, saplingItem)) {
                robot.swing(InteractionHand.MAIN_HAND);
            }
        }
        this.doStop(level, (LivingEntity)robot, gameTime);
    }

    private boolean tryReplant(ServerLevel level, MiniRobotEntity robot, BlockPos pos, Item saplingItem) {
        if (!(saplingItem instanceof BlockItem)) {
            return false;
        }
        int saplingSlot = -1;
        for (int i = 0; i < robot.getInventory().getContainerSize(); ++i) {
            if (!robot.getInventory().getItem(i).is(saplingItem)) continue;
            saplingSlot = i;
            break;
        }
        if (saplingSlot == -1) {
            return false;
        }
        BlockState saplingState = ((BlockItem)saplingItem).getBlock().defaultBlockState();
        if (level.getBlockState(pos).canBeReplaced() && saplingState.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, saplingState, 3);
            robot.getInventory().getItem(saplingSlot).shrink(1);
            robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.WOODCUTTING_ENERGY_COST_PER_REPLANT.get() * robot.getEnergyConsumptionModifier());
            return true;
        }
        return false;
    }

    protected void stop(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.REPLANT_POS.get());
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get());
    }
}

