/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.item;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.block.IRobotBlocks;
import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.item.BatteryItem;
import com.daqem.irobot.item.MiniRobotItem;
import com.daqem.irobot.item.RobotStationItem;
import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.TaskMarkerItem;
import com.daqem.irobot.item.TaskTableItem;
import com.daqem.irobot.item.module.ModuleItem;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public interface IRobotItems {
    public static final Registrar<Item> ITEMS = IRobot.MANAGER.get().get(Registries.ITEM);
    public static final RegistrySupplier<RobotStationItem> ROBOT_STATION = IRobotItems.register("robot_station", RobotStationItem::new);
    public static final RegistrySupplier<TaskTableItem> TASK_TABLE = IRobotItems.register("task_table", TaskTableItem::new);
    public static final RegistrySupplier<BlockItem> DROPOFF_CHEST = IRobotItems.register("dropoff_chest", p -> new BlockItem((Block)IRobotBlocks.DROPOFF_CHEST.get(), p));
    public static final RegistrySupplier<MiniRobotItem> MINI_ROBOT = IRobotItems.register("mini_robot", MiniRobotItem::new);
    public static final RegistrySupplier<TaskMarkerItem> TASK_MARKER = IRobotItems.register("task_marker", TaskMarkerItem::new);
    public static final RegistrySupplier<TaskItem> TASK = IRobotItems.register("task", TaskItem::new);
    public static final RegistrySupplier<BatteryItem> SMALL_BATTERY = IRobotItems.register("small_battery", p -> new BatteryItem((Item.Properties)p, (Integer)IRobotConfig.SMALL_BATTERY_CAPACITY.get()));
    public static final RegistrySupplier<BatteryItem> MEDIUM_BATTERY = IRobotItems.register("medium_battery", p -> new BatteryItem((Item.Properties)p, (Integer)IRobotConfig.MEDIUM_BATTERY_CAPACITY.get()));
    public static final RegistrySupplier<BatteryItem> LARGE_BATTERY = IRobotItems.register("large_battery", p -> new BatteryItem((Item.Properties)p, (Integer)IRobotConfig.LARGE_BATTERY_CAPACITY.get()));
    public static final RegistrySupplier<ModuleItem> SPEED_BOOST_MODULE = IRobotItems.register("speed_boost_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.SPEED_BOOST));
    public static final RegistrySupplier<ModuleItem> MINING_SPEED_MODULE = IRobotItems.register("mining_speed_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.MINING_SPEED));
    public static final RegistrySupplier<ModuleItem> ATTACK_DAMAGE_MODULE = IRobotItems.register("attack_damage_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.ATTACK_DAMAGE));
    public static final RegistrySupplier<ModuleItem> DURABILITY_MODULE = IRobotItems.register("durability_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.DURABILITY));
    public static final RegistrySupplier<ModuleItem> BATTERY_EFFICIENCY_MODULE = IRobotItems.register("battery_efficiency_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.BATTERY_EFFICIENCY));
    public static final RegistrySupplier<ModuleItem> SOLAR_PANEL_MODULE = IRobotItems.register("solar_panel_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.SOLAR_PANEL));
    public static final RegistrySupplier<ModuleItem> REFORESTATION_MODULE = IRobotItems.register("reforestation_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.REFORESTATION));
    public static final RegistrySupplier<ModuleItem> CROP_REPLANT_MODULE = IRobotItems.register("crop_replant_module", p -> new ModuleItem((Item.Properties)p, ModuleItem.ModuleType.CROP_REPLANT));
    public static final RegistrySupplier<Item> MICROCHIP = IRobotItems.register("microchip", Item::new);
    public static final RegistrySupplier<Item> ADVANCED_MICROCHIP = IRobotItems.register("advanced_microchip", Item::new);
    public static final RegistrySupplier<Item> MODULE_BASE = IRobotItems.register("module_base", Item::new);
    public static final RegistrySupplier<Item> BASIC_ROBOT_CHASSIS = IRobotItems.register("basic_robot_chassis", Item::new);

    public static void init() {
    }

    public static <T extends Item> RegistrySupplier<T> register(String name, Function<Item.Properties, T> constructor) {
        ResourceLocation id = IRobot.getId(name);
        return ITEMS.register(id, () -> (Item)constructor.apply(new Item.Properties().arch$tab(IRobot.IROBOT_TAB).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id))));
    }
}

