/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.item.module;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.item.module.IModuleItem;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class ModuleItem
extends Item
implements IModuleItem {
    private final ModuleType type;

    public ModuleItem(Item.Properties properties, ModuleType type) {
        super(properties.stacksTo(1));
        this.type = type;
    }

    public ModuleType getType() {
        return this.type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)IRobot.translatable("tooltip.module." + this.type.getSerializedName() + ".description").withStyle(ChatFormatting.GRAY));
    }

    public static enum ModuleType {
        SPEED_BOOST("speed_boost"),
        MINING_SPEED("mining_speed"),
        ATTACK_DAMAGE("attack_damage"),
        DURABILITY("durability"),
        BATTERY_EFFICIENCY("battery_efficiency"),
        SOLAR_PANEL("solar_panel"),
        REFORESTATION("reforestation"),
        CROP_REPLANT("crop_replant");

        private final String serializedName;

        private ModuleType(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }
    }
}

