/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.menu;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.block.IRobotBlocks;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.item.IRobotItems;
import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.data.IRobotDataComponents;
import com.daqem.irobot.item.data.TaskDataComponent;
import com.daqem.irobot.item.data.TaskMarkerDataComponent;
import com.daqem.irobot.menu.IRobotMenuTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Slot inputSlot;
    private final Container inputContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            TaskTableMenu.this.slotsChanged((Container)this);
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();
    private final Slot resultSlot;
    private final ContainerData data;
    private long lastSoundTime;
    @Nullable
    private RobotTask selectedTask = null;

    public TaskTableMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public TaskTableMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super((MenuType)IRobotMenuTypes.TASK_TABLE_MENU.get(), containerId);
        int slotX;
        this.access = access;
        this.data = new SimpleContainerData(1);
        this.inputSlot = this.addSlot(new Slot(this, this.inputContainer, 0, 111, 42){

            public int getMaxStackSize() {
                return 64;
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is((Item)IRobotItems.TASK_MARKER.get()) || stack.is((Item)IRobotItems.TASK.get());
            }

            public ResourceLocation getNoItemIcon() {
                return IRobot.getId("tasktable/task_marker_empty");
            }
        });
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 225, 42){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                stack.onCraftedBy(player, stack.getCount());
                TaskTableMenu.this.resultContainer.awardUsedRecipes(player, this.getRelevantItems());
                TaskDataComponent taskData = (TaskDataComponent)stack.get((DataComponentType)IRobotDataComponents.TASK_DATA.get());
                if (taskData != null && taskData.task().requiresArea()) {
                    TaskTableMenu.this.inputSlot.remove(1);
                }
                TaskTableMenu.this.createResult();
                access.execute((level, blockPos) -> {
                    long l = level.getGameTime();
                    if (TaskTableMenu.this.lastSoundTime != l) {
                        level.playSound(null, blockPos, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        TaskTableMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(TaskTableMenu.this.inputSlot.getItem());
            }
        });
        for (slotX = 0; slotX < 9; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                this.addSlot(new Slot((Container)playerInventory, slotX + slotY * 9 + 9, slotX * 19 + 92, slotY * 19 + 122));
            }
        }
        for (slotX = 0; slotX < 9; ++slotX) {
            this.addSlot(new Slot((Container)playerInventory, slotX, slotX * 19 + 92, 187));
        }
        this.addDataSlots(this.data);
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        if (container == this.inputContainer) {
            this.createResult();
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            Item item = itemStack2.getItem();
            itemStack = itemStack2.copy();
            if (index == 1) {
                item.onCraftedBy(itemStack2, player);
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index == 0 ? !this.moveItemStackTo(itemStack2, 2, 38, false) : (itemStack2.is((Item)IRobotItems.TASK_MARKER.get()) || itemStack2.is((Item)IRobotItems.TASK.get()) ? !this.moveItemStackTo(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemStack2, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
            if (index == 1) {
                player.drop(itemStack2, false);
            }
            this.broadcastChanges();
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return TaskTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)IRobotBlocks.TASK_TABLE.get()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0 && id < RobotTask.values().length) {
            this.selectedTask = RobotTask.values()[id];
            this.createResult();
            return true;
        }
        return false;
    }

    private void createResult() {
        this.resultSlot.set(ItemStack.EMPTY);
        this.data.set(0, 0);
        if (this.selectedTask == null) {
            return;
        }
        ItemStack inputStack = this.inputContainer.getItem(0);
        if (this.selectedTask.requiresArea()) {
            if (inputStack.isEmpty() || !inputStack.is((Item)IRobotItems.TASK_MARKER.get())) {
                this.data.set(0, 2);
                return;
            }
            TaskMarkerDataComponent markerData = (TaskMarkerDataComponent)inputStack.get((DataComponentType)IRobotDataComponents.TASK_MARKER_DATA.get());
            if (markerData == null || markerData.firstPos().pos() == BlockPos.ZERO || markerData.secondPos().pos() == BlockPos.ZERO) {
                this.data.set(0, 1);
                return;
            }
            ItemStack resultStack = ((TaskItem)((Object)IRobotItems.TASK.get())).getDefaultInstance();
            resultStack.set((DataComponentType)IRobotDataComponents.TASK_MARKER_DATA.get(), (Object)markerData);
            resultStack.set((DataComponentType)IRobotDataComponents.TASK_DATA.get(), (Object)new TaskDataComponent(this.selectedTask));
            this.resultSlot.set(resultStack);
        } else {
            ItemStack resultStack = ((TaskItem)((Object)IRobotItems.TASK.get())).getDefaultInstance();
            resultStack.set((DataComponentType)IRobotDataComponents.TASK_DATA.get(), (Object)new TaskDataComponent(this.selectedTask));
            this.resultSlot.set(resultStack);
        }
    }

    public int getErrorState() {
        return this.data.get(0);
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.inputContainer));
    }
}

