/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.following;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;

public class FollowAndProtectOwner
extends class_4097<MiniRobotEntity> {
    public FollowAndProtectOwner() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(class_3218 level, MiniRobotEntity robot) {
        class_1309 owner = robot.method_35057();
        return owner != null && !robot.method_60953() && !robot.method_60715();
    }

    protected boolean canStillUse(class_3218 level, MiniRobotEntity entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity);
    }

    protected void tick(class_3218 level, MiniRobotEntity robot, long gameTime) {
        class_1309 owner = robot.method_35057();
        if (owner == null) {
            return;
        }
        class_4095<IRobotEntity> brain = robot.method_18868();
        brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)owner, true));
        Optional<class_1309> nearestAttacker = this.findNearestAttacker(robot, owner);
        if (nearestAttacker.isPresent()) {
            brain.method_18878(class_4140.field_22355, (Object)nearestAttacker.get());
            return;
        }
        if (robot.method_60714()) {
            brain.method_18875(class_4140.field_18445);
            robot.method_60713();
            return;
        }
        double distanceSq = robot.method_5858((class_1297)owner);
        int followStartDistance = (Integer)IRobotConfig.FOLLOW_START_DISTANCE.get();
        int followStopDistance = (Integer)IRobotConfig.FOLLOW_STOP_DISTANCE.get();
        if (distanceSq > (double)(followStartDistance * followStartDistance)) {
            brain.method_18878(class_4140.field_18445, (Object)new class_4142((class_4115)new class_4102((class_1297)owner, false), ((Float)IRobotConfig.FOLLOW_OWNER_SPEED.get()).floatValue(), 2));
        } else if (distanceSq < (double)(followStopDistance * followStopDistance)) {
            brain.method_18875(class_4140.field_18445);
        }
    }

    private Optional<class_1309> findNearestAttacker(MiniRobotEntity robot, class_1309 owner) {
        int protectionRange = (Integer)IRobotConfig.PROTECT_OWNER_RANGE.get();
        return robot.method_18868().method_18904(class_4140.field_18441).flatMap(entities -> entities.stream().filter(entity -> entity instanceof class_1588 && entity.method_5805()).map(entity -> (class_1588)entity).filter(monster -> owner.equals((Object)monster.method_5968())).filter(arg_0 -> ((MiniRobotEntity)robot).method_6057(arg_0)).filter(monster -> monster.method_5858((class_1297)owner) < (double)(protectionRange * protectionRange)).map(monster -> monster).findFirst());
    }
}

