/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.following;

import com.daqem.irobot.entity.IRobotEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1811;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MeleeAttack
extends class_4097<IRobotEntity> {
    private final int attackCooldown;
    private final Predicate<IRobotEntity> canAttackPredicate;

    public MeleeAttack(int attackCooldown) {
        this(attackCooldown, mob -> true);
    }

    public MeleeAttack(int attackCooldown, Predicate<IRobotEntity> canAttackPredicate) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_22475, (Object)class_4141.field_18457, (Object)class_4140.field_18442, (Object)class_4141.field_18456));
        this.attackCooldown = attackCooldown;
        this.canAttackPredicate = canAttackPredicate;
    }

    private static boolean isTargetVisible(IRobotEntity mob, class_1309 target) {
        return mob.method_18868().method_18904(class_4140.field_18442).map(nearest -> nearest.method_38972(target)).orElse(false);
    }

    private static boolean isHoldingUsableProjectileWeapon(IRobotEntity mob) {
        return mob.method_24520(itemStack -> {
            class_1792 item = itemStack.method_7909();
            return item instanceof class_1811 && mob.method_25938((class_1811)item);
        });
    }

    protected boolean checkExtraStartConditions(class_3218 level, IRobotEntity mob) {
        class_1309 target = this.getAttackTarget(mob);
        return target != null && this.canAttackPredicate.test(mob) && !MeleeAttack.isHoldingUsableProjectileWeapon(mob) && mob.method_42150(target) && MeleeAttack.isTargetVisible(mob, target);
    }

    protected boolean canStillUse(class_3218 level, IRobotEntity entity, long gameTime) {
        class_1309 target = this.getAttackTarget(entity);
        return target != null && entity.method_42150(target) && MeleeAttack.isTargetVisible(entity, target);
    }

    protected void start(class_3218 level, IRobotEntity mob, long gameTime) {
        class_1309 target = this.getAttackTarget(mob);
        if (target == null) {
            this.method_18925(level, (class_1309)mob, gameTime);
            return;
        }
        mob.method_18868().method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)target, true));
        mob.getInventory().selectBestWeapon(target);
        mob.method_6104(class_1268.field_5808);
        mob.method_6121(level, (class_1297)target);
        mob.method_18868().method_24525(class_4140.field_22475, (Object)true, (long)this.attackCooldown);
    }

    private class_1309 getAttackTarget(IRobotEntity mob) {
        return mob.method_18868().method_18904(class_4140.field_22355).orElse(null);
    }
}

