/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.mining;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;

public class MineBlock
extends class_4097<MiniRobotEntity> {
    private static final double MAX_REACH_DISTANCE_SQ = 20.25;
    private static final double PREFERRED_REACH_DISTANCE_SQ = 9.0;
    private float miningProgress;
    private int lastBreakProgress = -1;
    private int retryCounter = 0;
    private class_2338 targetPos;
    private int miningTicks;

    public MineBlock() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get()), (Object)class_4141.field_18456));
    }

    protected void start(class_3218 level, MiniRobotEntity robot, long gameTime) {
        this.miningProgress = 0.0f;
        this.lastBreakProgress = -1;
        this.retryCounter = 0;
        this.miningTicks = 0;
        robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get()).ifPresent(globalPos -> {
            this.targetPos = globalPos.comp_2208();
            robot.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetPos));
            class_2680 blockState = level.method_8320(this.targetPos);
            robot.setBestToolForBlock(blockState);
        });
        robot.setMining(true);
    }

    protected boolean method_18915(long gameTime) {
        return this.miningTicks > (Integer)IRobotConfig.MINE_BLOCK_TIMEOUT_TICKS.get();
    }

    protected void stop(class_3218 level, MiniRobotEntity robot, long gameTime) {
        robot.setMining(false);
        if (this.targetPos != null) {
            level.method_8517(robot.method_5628(), this.targetPos, -1);
        }
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        robot.method_18868().method_18875(class_4140.field_18446);
        this.targetPos = null;
    }

    protected void tick(class_3218 level, MiniRobotEntity robot, long gameTime) {
        Optional minePosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        if (minePosOpt.isEmpty() || !((class_4208)minePosOpt.get()).comp_2208().equals((Object)this.targetPos)) {
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        class_2338 currentTargetPos = ((class_4208)minePosOpt.get()).comp_2208();
        class_2680 blockState = level.method_8320(currentTargetPos);
        if (blockState.method_26215() || blockState.method_26214((class_1922)level, currentTargetPos) == -1.0f) {
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        double distanceSq = robot.method_19538().method_1025(class_243.method_24953((class_2382)currentTargetPos));
        if (distanceSq > 20.25) {
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        if (distanceSq > 9.0) {
            if (this.retryCounter < (Integer)IRobotConfig.MINE_BLOCK_RETRY_ATTEMPTS.get()) {
                robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(currentTargetPos, 0.5f, 1));
                ++this.retryCounter;
                return;
            }
            this.method_18925(level, (class_1309)robot, gameTime);
            return;
        }
        robot.method_18868().method_18875(class_4140.field_18445);
        ++this.miningTicks;
        float destroySpeed = robot.getDestroySpeed(blockState);
        float blockHardness = blockState.method_26214((class_1922)level, currentTargetPos);
        if (blockHardness == 0.0f) {
            this.miningProgress = 1.0f;
        } else {
            int i = robot.hasCorrectToolForDrops(blockState) ? 30 : 100;
            float progressPerTick = destroySpeed / blockHardness / (float)i;
            this.miningProgress += progressPerTick;
        }
        int currentBreakProgress = (int)(this.miningProgress * 10.0f);
        if (currentBreakProgress != this.lastBreakProgress) {
            level.method_8517(robot.method_5628(), currentTargetPos, currentBreakProgress);
            this.lastBreakProgress = currentBreakProgress;
        }
        if (this.miningProgress >= 1.0f) {
            if (level.method_8651(currentTargetPos, robot.hasCorrectToolForDrops(blockState), (class_1297)robot)) {
                robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.MINING_ENERGY_COST_PER_BLOCK.get() * robot.getEnergyConsumptionModifier());
            }
            this.method_18925(level, (class_1309)robot, gameTime);
        }
    }

    protected boolean canStillUse(class_3218 level, MiniRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            return false;
        }
        Optional minePos = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        if (minePos.isEmpty() || !((class_4208)minePos.get()).comp_2208().equals((Object)this.targetPos)) {
            return false;
        }
        if (level.method_8320(this.targetPos).method_26215()) {
            return false;
        }
        return robot.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPos)) <= 20.25;
    }
}

