/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.woodcutting;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4538;

public class ReplantTree
extends class_4097<MiniRobotEntity> {
    public ReplantTree() {
        super((Map)ImmutableMap.of((Object)((class_4140)IRobotMemoryModuleTypes.REPLANT_POS.get()), (Object)class_4141.field_18456, (Object)((class_4140)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get()), (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(class_3218 level, MiniRobotEntity robot) {
        return robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()).isEmpty();
    }

    protected void start(class_3218 level, MiniRobotEntity robot, long gameTime) {
        Optional replantPosOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.REPLANT_POS.get());
        Optional saplingItemOpt = robot.method_18868().method_18904((class_4140)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get());
        if (replantPosOpt.isPresent() && saplingItemOpt.isPresent()) {
            class_2338 replantPos = (class_2338)replantPosOpt.get();
            class_1792 saplingItem = (class_1792)saplingItemOpt.get();
            if (!robot.getInventory().contains(saplingItem.method_7854())) {
                this.method_18925(level, (class_1309)robot, gameTime);
                return;
            }
            if (!replantPos.method_19771((class_2382)robot.method_24515(), 3.0)) {
                robot.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(replantPos, 0.5f, 1));
                return;
            }
            if (this.tryReplant(level, robot, replantPos, saplingItem)) {
                robot.method_6104(class_1268.field_5808);
            }
        }
        this.method_18925(level, (class_1309)robot, gameTime);
    }

    private boolean tryReplant(class_3218 level, MiniRobotEntity robot, class_2338 pos, class_1792 saplingItem) {
        if (!(saplingItem instanceof class_1747)) {
            return false;
        }
        int saplingSlot = -1;
        for (int i = 0; i < robot.getInventory().method_5439(); ++i) {
            if (!robot.getInventory().method_5438(i).method_31574(saplingItem)) continue;
            saplingSlot = i;
            break;
        }
        if (saplingSlot == -1) {
            return false;
        }
        class_2680 saplingState = ((class_1747)saplingItem).method_7711().method_9564();
        if (level.method_8320(pos).method_45474() && saplingState.method_26184((class_4538)level, pos)) {
            level.method_8652(pos, saplingState, 3);
            robot.getInventory().method_5438(saplingSlot).method_7934(1);
            robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.WOODCUTTING_ENERGY_COST_PER_REPLANT.get() * robot.getEnergyConsumptionModifier());
            return true;
        }
        return false;
    }

    protected void stop(class_3218 level, MiniRobotEntity robot, long gameTime) {
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.REPLANT_POS.get());
        robot.method_18868().method_18875((class_4140)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get());
    }
}

