/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.block.entity;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.block.IRobotBlocks;
import com.daqem.irobot.block.entity.DropoffChestBlockEntity;
import com.daqem.irobot.block.entity.RobotStationBlockEntity;
import com.daqem.irobot.block.entity.TaskTableBlockEntity;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface IRobotBlockEntities {
    public static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = IRobot.MANAGER.get().get(Registries.BLOCK_ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<RobotStationBlockEntity>> ROBOT_STATION = IRobotBlockEntities.register("robot_station", RobotStationBlockEntity::new, IRobotBlocks.ROBOT_STATION);
    public static final RegistrySupplier<BlockEntityType<TaskTableBlockEntity>> TASK_TABLE = IRobotBlockEntities.register("task_table", TaskTableBlockEntity::new, IRobotBlocks.TASK_TABLE);
    public static final RegistrySupplier<BlockEntityType<DropoffChestBlockEntity>> DROPOFF_CHEST = IRobotBlockEntities.register("dropoff_chest", DropoffChestBlockEntity::new, IRobotBlocks.DROPOFF_CHEST);

    public static void init() {
    }

    @SafeVarargs
    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> supplier, RegistrySupplier<? extends Block> ... validBlockSuppliers) {
        return BLOCK_ENTITY_TYPES.register(IRobot.getId(name), () -> {
            Set validBlocks = Arrays.stream(validBlockSuppliers).map(Supplier::get).collect(Collectors.toSet());
            return new BlockEntityType(supplier, validBlocks);
        });
    }
}

