/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.following;

import com.daqem.irobot.entity.IRobotEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;

public class MeleeAttack
extends Behavior<IRobotEntity> {
    private final int attackCooldown;
    private final Predicate<IRobotEntity> canAttackPredicate;

    public MeleeAttack(int attackCooldown) {
        this(attackCooldown, mob -> true);
    }

    public MeleeAttack(int attackCooldown, Predicate<IRobotEntity> canAttackPredicate) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
        this.attackCooldown = attackCooldown;
        this.canAttackPredicate = canAttackPredicate;
    }

    private static boolean isTargetVisible(IRobotEntity mob, LivingEntity target) {
        return mob.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).map(nearest -> nearest.contains(target)).orElse(false);
    }

    private static boolean isHoldingUsableProjectileWeapon(IRobotEntity mob) {
        return mob.isHolding(itemStack -> {
            Item item = itemStack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity mob) {
        LivingEntity target = this.getAttackTarget(mob);
        return target != null && this.canAttackPredicate.test(mob) && !MeleeAttack.isHoldingUsableProjectileWeapon(mob) && mob.isWithinMeleeAttackRange(target) && MeleeAttack.isTargetVisible(mob, target);
    }

    protected boolean canStillUse(ServerLevel level, IRobotEntity entity, long gameTime) {
        LivingEntity target = this.getAttackTarget(entity);
        return target != null && entity.isWithinMeleeAttackRange(target) && MeleeAttack.isTargetVisible(entity, target);
    }

    protected void start(ServerLevel level, IRobotEntity mob, long gameTime) {
        LivingEntity target = this.getAttackTarget(mob);
        if (target == null) {
            this.doStop(level, (LivingEntity)mob, gameTime);
            return;
        }
        mob.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
        mob.getInventory().selectBestWeapon(target);
        mob.swing(InteractionHand.MAIN_HAND);
        mob.doHurtTarget(level, (Entity)target);
        mob.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.attackCooldown);
    }

    private LivingEntity getAttackTarget(IRobotEntity mob) {
        return mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }
}

