/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.mining;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MineBlock
extends Behavior<MiniRobotEntity> {
    private static final double MAX_REACH_DISTANCE_SQ = 20.25;
    private static final double PREFERRED_REACH_DISTANCE_SQ = 9.0;
    private float miningProgress;
    private int lastBreakProgress = -1;
    private int retryCounter = 0;
    private BlockPos targetPos;
    private int miningTicks;

    public MineBlock() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected void start(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        this.miningProgress = 0.0f;
        this.lastBreakProgress = -1;
        this.retryCounter = 0;
        this.miningTicks = 0;
        robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get()).ifPresent(globalPos -> {
            this.targetPos = globalPos.pos();
            robot.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
            BlockState blockState = level.getBlockState(this.targetPos);
            robot.setBestToolForBlock(blockState);
        });
        robot.setMining(true);
    }

    protected boolean timedOut(long gameTime) {
        return this.miningTicks > (Integer)IRobotConfig.MINE_BLOCK_TIMEOUT_TICKS.get();
    }

    protected void stop(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        robot.setMining(false);
        if (this.targetPos != null) {
            level.destroyBlockProgress(robot.getId(), this.targetPos, -1);
        }
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        robot.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.targetPos = null;
    }

    protected void tick(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        Optional minePosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        if (minePosOpt.isEmpty() || !((GlobalPos)minePosOpt.get()).pos().equals((Object)this.targetPos)) {
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        BlockPos currentTargetPos = ((GlobalPos)minePosOpt.get()).pos();
        BlockState blockState = level.getBlockState(currentTargetPos);
        if (blockState.isAir() || blockState.getDestroySpeed((BlockGetter)level, currentTargetPos) == -1.0f) {
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        double distanceSq = robot.position().distanceToSqr(Vec3.atCenterOf((Vec3i)currentTargetPos));
        if (distanceSq > 20.25) {
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        if (distanceSq > 9.0) {
            if (this.retryCounter < (Integer)IRobotConfig.MINE_BLOCK_RETRY_ATTEMPTS.get()) {
                robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(currentTargetPos, 0.5f, 1));
                ++this.retryCounter;
                return;
            }
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        robot.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        ++this.miningTicks;
        float destroySpeed = robot.getDestroySpeed(blockState);
        float blockHardness = blockState.getDestroySpeed((BlockGetter)level, currentTargetPos);
        if (blockHardness == 0.0f) {
            this.miningProgress = 1.0f;
        } else {
            int i = robot.hasCorrectToolForDrops(blockState) ? 30 : 100;
            float progressPerTick = destroySpeed / blockHardness / (float)i;
            this.miningProgress += progressPerTick;
        }
        int currentBreakProgress = (int)(this.miningProgress * 10.0f);
        if (currentBreakProgress != this.lastBreakProgress) {
            level.destroyBlockProgress(robot.getId(), currentTargetPos, currentBreakProgress);
            this.lastBreakProgress = currentBreakProgress;
        }
        if (this.miningProgress >= 1.0f) {
            if (level.destroyBlock(currentTargetPos, robot.hasCorrectToolForDrops(blockState), (Entity)robot)) {
                robot.setEnergy(robot.getEnergy() - (Double)IRobotConfig.MINING_ENERGY_COST_PER_BLOCK.get() * robot.getEnergyConsumptionModifier());
            }
            this.doStop(level, (LivingEntity)robot, gameTime);
        }
    }

    protected boolean canStillUse(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            return false;
        }
        Optional minePos = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get());
        if (minePos.isEmpty() || !((GlobalPos)minePos.get()).pos().equals((Object)this.targetPos)) {
            return false;
        }
        if (level.getBlockState(this.targetPos).isAir()) {
            return false;
        }
        return robot.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos)) <= 20.25;
    }
}

