/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.protecting;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StrollInArea
extends Behavior<MiniRobotEntity> {
    private long lastStrollTime;

    public StrollInArea() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, MiniRobotEntity owner) {
        return owner.level().getGameTime() - this.lastStrollTime >= (long)((Integer)IRobotConfig.STROLL_IN_AREA_COOLDOWN_TICKS.get()).intValue();
    }

    protected void start(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        AABB protectionArea = OutlineRenderer.createBoundingBox(((GlobalPos)startPosOpt.get()).pos(), ((GlobalPos)endPosOpt.get()).pos());
        Optional<Vec3> targetPos = this.findRandomPosInAABB(robot, protectionArea);
        targetPos.ifPresent(pos -> {
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, 0.5f, 1));
            this.lastStrollTime = gameTime;
        });
    }

    private Optional<Vec3> findRandomPosInAABB(MiniRobotEntity robot, AABB aabb) {
        RandomSource random = robot.getRandom();
        for (int i = 0; i < 10; ++i) {
            double z;
            double y;
            double x = aabb.minX + aabb.getXsize() * random.nextDouble();
            BlockPos targetPos = BlockPos.containing((double)x, (double)(y = aabb.minY + aabb.getYsize() * random.nextDouble()), (double)(z = aabb.minZ + aabb.getZsize() * random.nextDouble()));
            Vec3 safePos = DefaultRandomPos.getPosTowards((PathfinderMob)robot, (int)10, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)targetPos), (double)1.5707963705062866);
            if (safePos == null || !aabb.contains(safePos)) continue;
            return Optional.of(safePos);
        }
        return Optional.empty();
    }
}

