/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.woodcutting;

import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.util.TreeUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CutDownTree
extends Behavior<MiniRobotEntity> {
    private static final double MAX_REACH_DISTANCE_SQ = 12.25;
    private static final double PREFERRED_REACH_DISTANCE_SQ = 6.25;
    private int ticksSinceStarted;
    private int totalTicksToCut;
    private BlockPos targetPos;
    private int retryCounter = 0;

    public CutDownTree() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean timedOut(long gameTime) {
        return this.ticksSinceStarted > (Integer)IRobotConfig.CUT_TREE_TIMEOUT_TICKS.get();
    }

    protected void start(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        this.ticksSinceStarted = 0;
        this.retryCounter = 0;
        robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()).ifPresent(globalPos -> {
            this.targetPos = globalPos.pos();
            robot.setMining(true);
            robot.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
            BlockState blockState = level.getBlockState(this.targetPos);
            robot.setBestToolForBlock(blockState);
            Set<BlockPos> treeBlocks = TreeUtils.getTreeBlocks(level, this.targetPos);
            float destroySpeed = robot.getDestroySpeed(blockState);
            float blockHardness = blockState.getDestroySpeed((BlockGetter)level, this.targetPos);
            if (blockHardness <= 0.0f) {
                this.totalTicksToCut = treeBlocks.isEmpty() ? 20 : treeBlocks.size();
            } else {
                int i = robot.hasCorrectToolForDrops(blockState) ? 30 : 100;
                float ticksPerBlock = blockHardness * (float)i / destroySpeed;
                this.totalTicksToCut = (int)((float)treeBlocks.size() * ticksPerBlock);
            }
        });
    }

    protected void stop(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        robot.setMining(false);
        if (this.targetPos != null) {
            level.destroyBlockProgress(robot.getId(), this.targetPos, -1);
        }
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get());
        robot.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.targetPos = null;
    }

    protected void tick(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        Optional treePosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get());
        if (treePosOpt.isEmpty() || !((GlobalPos)treePosOpt.get()).pos().equals((Object)this.targetPos)) {
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        double distanceSq = robot.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos));
        if (distanceSq > 12.25) {
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        if (distanceSq > 6.25) {
            if (this.retryCounter < (Integer)IRobotConfig.CUT_TREE_RETRY_ATTEMPTS.get()) {
                robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, 0.5f, 1));
                ++this.retryCounter;
                return;
            }
            this.doStop(level, (LivingEntity)robot, gameTime);
            return;
        }
        robot.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        ++this.ticksSinceStarted;
        if (this.totalTicksToCut > 0) {
            int progress = (int)((float)this.ticksSinceStarted / (float)this.totalTicksToCut * 10.0f);
            level.destroyBlockProgress(robot.getId(), this.targetPos, progress);
        }
        if (this.ticksSinceStarted >= this.totalTicksToCut) {
            Set<BlockPos> treeBlocks = TreeUtils.getTreeBlocks(level, this.targetPos);
            BlockState logState = level.getBlockState(this.targetPos);
            boolean canHarvest = robot.hasCorrectToolForDrops(logState);
            for (BlockPos pos : treeBlocks) {
                level.destroyBlock(pos, canHarvest, (Entity)robot);
            }
            robot.setEnergy(robot.getEnergy() - (double)treeBlocks.size() * (Double)IRobotConfig.WOODCUTTING_ENERGY_COST_PER_LOG.get() * robot.getEnergyConsumptionModifier());
            this.doStop(level, (LivingEntity)robot, gameTime);
        }
    }

    protected boolean canStillUse(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        if (this.targetPos == null) {
            return false;
        }
        Optional treePos = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get());
        if (treePos.isEmpty() || !((GlobalPos)treePos.get()).pos().equals((Object)this.targetPos)) {
            return false;
        }
        if (!level.getBlockState(this.targetPos).is(BlockTags.LOGS)) {
            return false;
        }
        return robot.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos)) <= 12.25;
    }
}

