/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.task;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.entity.ai.IRobotActivities;
import com.mojang.serialization.Codec;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.NotNull;

public enum RobotTask implements StringRepresentable
{
    PROTECTING("protecting", true),
    MINING("mining", true),
    WOODCUTTING("woodcutting", true),
    FARMING("farming", true),
    FOLLOWING("following", false);

    public static final Codec<RobotTask> CODEC;
    private final String name;
    private final boolean requiresArea;

    private RobotTask(String name, boolean requiresArea) {
        this.name = name;
        this.requiresArea = requiresArea;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Component getName() {
        return IRobot.translatable("task." + this.name);
    }

    public boolean requiresArea() {
        return this.requiresArea;
    }

    public Activity getActivity() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Activity)IRobotActivities.PROTECT.get();
            case 1 -> (Activity)IRobotActivities.MINE.get();
            case 2 -> (Activity)IRobotActivities.CUT_WOOD.get();
            case 3 -> (Activity)IRobotActivities.FARM.get();
            case 4 -> (Activity)IRobotActivities.FOLLOW.get();
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(RobotTask::values);
    }
}

