/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.item;

import com.daqem.irobot.item.data.BatteryDataComponent;
import com.daqem.irobot.item.data.IRobotDataComponents;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.NotNull;

public class BatteryItem
extends Item {
    private final int maxEnergy;

    public BatteryItem(Item.Properties properties, int maxEnergy) {
        super(properties.stacksTo(1));
        this.maxEnergy = maxEnergy;
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set((DataComponentType)IRobotDataComponents.BATTERY_DATA.get(), (Object)new BatteryDataComponent(this.maxEnergy, this.maxEnergy));
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        BatteryDataComponent batteryData = (BatteryDataComponent)stack.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get());
        if (batteryData != null) {
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.irobot.energy", (Object[])new Object[]{batteryData.energy(), batteryData.maxEnergy()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        BatteryDataComponent batteryData = (BatteryDataComponent)stack.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get());
        if (batteryData == null) {
            return 0;
        }
        return Math.round(13.0f * (float)batteryData.energy() / (float)batteryData.maxEnergy());
    }

    public int getBarColor(ItemStack stack) {
        return 65280;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }
}

