/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.item.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record BatteryDataComponent(double energy, double maxEnergy) {
    public static final Codec<BatteryDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("energy").forGetter(BatteryDataComponent::energy), (App)Codec.DOUBLE.fieldOf("max_energy").forGetter(BatteryDataComponent::maxEnergy)).apply((Applicative)instance, BatteryDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BatteryDataComponent> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        buf.writeDouble(data.energy());
        buf.writeDouble(data.maxEnergy());
    }, buf -> new BatteryDataComponent(buf.readDouble(), buf.readDouble()));

    public BatteryDataComponent withEnergy(double energy) {
        return new BatteryDataComponent(Math.max(0.0, Math.min(energy, this.maxEnergy)), this.maxEnergy);
    }
}

