/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.block;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.block.DropoffChestBlock;
import com.daqem.irobot.block.RobotStationBlock;
import com.daqem.irobot.block.TaskTableBlock;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public interface IRobotBlocks {
    public static final Registrar<Block> BLOCKS = IRobot.MANAGER.get().get(Registries.BLOCK);
    public static final RegistrySupplier<Block> ROBOT_STATION = IRobotBlocks.register("robot_station", BlockBehaviour.Properties.of(), RobotStationBlock::new);
    public static final RegistrySupplier<Block> TASK_TABLE = IRobotBlocks.register("task_table", BlockBehaviour.Properties.of(), TaskTableBlock::new);
    public static final RegistrySupplier<Block> DROPOFF_CHEST = IRobotBlocks.register("dropoff_chest", BlockBehaviour.Properties.of().strength(2.5f), DropoffChestBlock::new);

    public static void init() {
    }

    public static <T extends Block> RegistrySupplier<T> register(String name, BlockBehaviour.Properties properties, Function<BlockBehaviour.Properties, T> constructor) {
        ResourceLocation id = IRobot.getId(name);
        return BLOCKS.register(id, () -> (Block)constructor.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id))));
    }
}

