/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.block;

import com.daqem.irobot.block.entity.IRobotBlockEntities;
import com.daqem.irobot.block.entity.RobotStationBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RobotStationBlock
extends BaseEntityBlock {
    public static final MapCodec<RobotStationBlock> CODEC = RobotStationBlock.simpleCodec(RobotStationBlock::new);

    public RobotStationBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)IRobotBlockEntities.ROBOT_STATION.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : RobotStationBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)IRobotBlockEntities.ROBOT_STATION.get()), RobotStationBlockEntity::serverTick);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)3.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0)});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

