/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.block;

import com.daqem.irobot.block.entity.IRobotBlockEntities;
import com.daqem.irobot.block.entity.TaskTableBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskTableBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty HAS_TASK_AREA = BlockStateProperties.HAS_BOOK;
    public static final BooleanProperty HAS_TASK = BlockStateProperties.HAS_RECORD;
    public static final MapCodec<TaskTableBlock> CODEC = TaskTableBlock.simpleCodec(TaskTableBlock::new);
    private static final VoxelShape SHAPE_COLLISION = Shapes.or((VoxelShape)Block.column((double)6.0, (double)0.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.column((double)4.0, (double)3.0, (double)9.0), Block.column((double)6.0, (double)9.0, (double)11.0), Block.boxZ((double)6.0, (double)11.0, (double)13.0, (double)8.0, (double)11.0)});
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal((VoxelShape)Shapes.or((VoxelShape)Block.boxZ((double)14.0, (double)7.5, (double)9.5, (double)2.0, (double)5.5), (VoxelShape[])new VoxelShape[]{Block.boxZ((double)14.0, (double)9.5, (double)11.5, (double)4.4, (double)7.9), Block.boxZ((double)14.0, (double)11.5, (double)13.5, (double)6.8, (double)10.3), Block.boxZ((double)14.0, (double)13.5, (double)15.5, (double)9.25, (double)12.75), SHAPE_COLLISION}));

    public TaskTableBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_TASK, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_TASK_AREA, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected VoxelShape getOcclusionShape(BlockState state) {
        return SHAPE_COLLISION;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        ItemStack itemStack = context.getItemInHand();
        Player player = context.getPlayer();
        boolean hasTaskArea = false;
        boolean hasTask = false;
        if (!level.isClientSide && player != null && player.canUseGameMasterBlocks()) {
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
            if (customData.contains("TaskArea")) {
                hasTaskArea = true;
            }
            if (customData.contains("Task")) {
                hasTask = true;
                hasTaskArea = false;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)HAS_TASK_AREA, (Comparable)Boolean.valueOf(hasTaskArea))).setValue((Property)HAS_TASK, (Comparable)Boolean.valueOf(hasTask));
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_COLLISION;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(FACING));
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_TASK_AREA, HAS_TASK});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)IRobotBlockEntities.TASK_TABLE.get()).create(pos, state);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TaskTableBlockEntity) {
            TaskTableBlockEntity taskTable = (TaskTableBlockEntity)blockEntity;
            player.openMenu((MenuProvider)taskTable);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

