/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.gui.robot;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.client.gui.robot.components.RobotComponent;
import com.daqem.irobot.menu.RobotMenu;
import com.daqem.uilib.api.background.IBackground;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.AbstractContainerScreen;
import com.daqem.uilib.gui.background.BlurredBackground;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RobotScreen
extends AbstractContainerScreen<RobotMenu> {
    public RobotScreen(RobotMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.setBackground((IBackground)new BlurredBackground());
    }

    protected void init() {
        RobotComponent component = new RobotComponent(((RobotMenu)this.menu)::getRobotEntityId);
        component.center();
        this.addComponent((IComponent)component);
        this.imageHeight = component.getHeight();
        this.imageWidth = component.getWidth();
        super.init();
        this.leftPos = component.getX();
        this.topPos = component.getY();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 24, 108, -10227973, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 160, 108, -10227973, false);
        int health = ((RobotMenu)this.menu).getHealth();
        int maxHealth = ((RobotMenu)this.menu).getMaxHealth();
        int energy = ((RobotMenu)this.menu).getEnergy();
        int maxEnergy = ((RobotMenu)this.menu).getMaxEnergy();
        Activity currentActivity = ((RobotMenu)this.menu).getActiveActivity() == null ? Activity.IDLE : ((RobotMenu)this.menu).getActiveActivity();
        MutableComponent statsComponent = IRobot.translatable("gui.robot.stats").withStyle(ChatFormatting.BOLD);
        MutableComponent healthComponent = IRobot.translatable("gui.robot.health", health, maxHealth);
        MutableComponent energyComponent = IRobot.translatable("gui.robot.energy", energy, maxEnergy);
        MutableComponent activityComponent = IRobot.translatable("gui.robot.current_activity", IRobot.translatable("gui.robot.activity." + currentActivity.getName()));
        guiGraphics.drawString(this.font, (Component)statsComponent, 160, 20, -10227973, false);
        guiGraphics.drawString(this.font, (Component)healthComponent, 160, 30, -10227973, false);
        guiGraphics.drawString(this.font, (Component)energyComponent, 160, 40, -10227973, false);
        guiGraphics.drawString(this.font, (Component)activityComponent, 160, 50, -10227973, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

