/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.gui.robot.components;

import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.uilib.gui.component.AbstractComponent;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityComponent
extends AbstractComponent {
    private final Supplier<Integer> entityIdSupplier;

    public EntityComponent(int x, int y, int width, int height, Supplier<Integer> entityIdSupplier) {
        super(x, y, width, height);
        this.entityIdSupplier = entityIdSupplier;
    }

    public void renderEntity(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(this.entityIdSupplier.get().intValue());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int scale = livingEntity instanceof MiniRobotEntity ? 40 : 30;
            float yOffset = livingEntity instanceof MiniRobotEntity ? 0.25f : 0.0625f;
            float f = (float)(this.getTotalX() + this.getTotalX() + this.getWidth()) / 2.0f;
            float g = (float)(this.getTotalY() + this.getTotalY() + this.getHeight()) / 2.0f;
            guiGraphics.enableScissor(this.getTotalX(), this.getTotalY(), this.getTotalX() + this.getWidth(), this.getTotalY() + this.getHeight());
            float h = (float)Math.atan((f - (float)mouseX) / 40.0f);
            float i = (float)Math.atan((g - (float)mouseY) / 40.0f);
            Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
            Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
            quaternionf.mul((Quaternionfc)quaternionf2);
            float j = livingEntity.yBodyRot;
            float k = livingEntity.getYRot();
            float l = livingEntity.getXRot();
            float m = livingEntity.yHeadRotO;
            float n = livingEntity.yHeadRot;
            livingEntity.yBodyRot = 180.0f + h * 20.0f;
            livingEntity.setYRot(180.0f + h * 40.0f);
            livingEntity.setXRot(-i * 20.0f);
            livingEntity.yHeadRot = livingEntity.getYRot();
            livingEntity.yHeadRotO = livingEntity.getYRot();
            float o = livingEntity.getScale();
            Vector3f vector3f = new Vector3f(0.0f, livingEntity.getBbHeight() / 2.0f + yOffset * o, 0.0f);
            float p = (float)scale / o;
            EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer((Entity)livingEntity);
            EntityRenderState entityRenderState = entityRenderer.createRenderState((Entity)livingEntity, 1.0f);
            entityRenderState.hitboxesRenderState = null;
            guiGraphics.submitEntityRenderState(entityRenderState, p, vector3f, quaternionf, quaternionf2, this.getTotalX(), this.getTotalY(), this.getTotalX() + this.getWidth(), this.getTotalY() + this.getHeight());
            livingEntity.yBodyRot = j;
            livingEntity.setYRot(k);
            livingEntity.setXRot(l);
            livingEntity.yHeadRotO = m;
            livingEntity.yHeadRot = n;
            guiGraphics.disableScissor();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        this.renderEntity(guiGraphics, mouseX, mouseY);
    }
}

