/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.gui.tasktable;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.client.gui.tasktable.TaskTableScreenState;
import com.daqem.irobot.client.gui.tasktable.components.TaskTableComponent;
import com.daqem.irobot.menu.TaskTableMenu;
import com.daqem.uilib.api.background.IBackground;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.AbstractContainerScreen;
import com.daqem.uilib.gui.background.BlurredBackground;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TaskTableScreen
extends AbstractContainerScreen<TaskTableMenu> {
    private final TaskTableScreenState state;

    public TaskTableScreen(TaskTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.state = new TaskTableScreenState(menu.containerId);
        this.setBackground((IBackground)new BlurredBackground());
    }

    protected void init() {
        TaskTableComponent component = new TaskTableComponent(this.state);
        component.center();
        this.addComponent((IComponent)component);
        this.imageHeight = component.getHeight();
        this.imageWidth = component.getWidth();
        super.init();
        this.leftPos = component.getX();
        this.topPos = component.getY();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 92, 19, -10227973, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 92, 108, -10227973, false);
        guiGraphics.drawString(this.font, (Component)IRobot.translatable("gui.tasktable.modes"), 111, 68, -10227973, false);
        this.renderError(guiGraphics);
    }

    private void renderError(GuiGraphics guiGraphics) {
        MutableComponent errorMessage;
        int errorState = ((TaskTableMenu)this.menu).getErrorState();
        if (errorState == 0) {
            return;
        }
        switch (errorState) {
            case 1: {
                MutableComponent mutableComponent = IRobot.translatable("gui.tasktable.error.area_not_defined");
                break;
            }
            case 2: {
                MutableComponent mutableComponent = IRobot.translatable("gui.tasktable.error.no_marker");
                break;
            }
            default: {
                MutableComponent mutableComponent = errorMessage = null;
            }
        }
        if (errorMessage != null) {
            int textWidth = this.font.width((FormattedText)errorMessage);
            int x = 176 - textWidth / 2;
            int y = 29;
            guiGraphics.drawString(this.font, (Component)errorMessage, x, y, -43691, false);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

