/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.renderer.block;

import com.daqem.irobot.IRobot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DropoffChestBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ChestModel singleModel;
    private final ChestModel doubleLeftModel;
    private final ChestModel doubleRightModel;

    public DropoffChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.singleModel = new ChestModel(context.bakeLayer(ModelLayers.CHEST));
        this.doubleLeftModel = new ChestModel(context.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT));
        this.doubleRightModel = new ChestModel(context.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT));
    }

    public static boolean xmasTextures() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        Level level = blockEntity.getLevel();
        boolean bl = level != null;
        BlockState blockState = bl ? blockEntity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockState.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockState.getBlock();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractChestBlock = (AbstractChestBlock)block;
            boolean bl2 = chestType != ChestType.SINGLE;
            poseStack.pushPose();
            float f = ((Direction)blockState.getValue((Property)ChestBlock.FACING)).toYRot();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborCombineResult = bl ? abstractChestBlock.combine(blockState, level, blockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float g = ((Float2FloatFunction)neighborCombineResult.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)blockEntity)))).get(partialTick);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)neighborCombineResult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material material = new MaterialMapper(ResourceLocation.withDefaultNamespace((String)"textures/atlas/chest.png"), "entity/chest").apply(chestType == ChestType.SINGLE ? IRobot.getId("normal") : (chestType == ChestType.LEFT ? IRobot.getId("normal_left") : IRobot.getId("normal_right")));
            VertexConsumer vertexConsumer = material.buffer(bufferSource, RenderType::entityCutout);
            if (bl2) {
                if (chestType == ChestType.LEFT) {
                    this.render(poseStack, vertexConsumer, this.doubleLeftModel, g, i, packedOverlay);
                } else {
                    this.render(poseStack, vertexConsumer, this.doubleRightModel, g, i, packedOverlay);
                }
            } else {
                this.render(poseStack, vertexConsumer, this.singleModel, g, i, packedOverlay);
            }
            poseStack.popPose();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer buffer, ChestModel model, float openness, int packedLight, int packedOverlay) {
        model.setupAnim(openness);
        model.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
    }
}

