/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.InteractableRobot;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.RobotEquipment;
import com.daqem.irobot.entity.RobotInventory;
import com.daqem.irobot.entity.ai.IRobotActivities;
import com.daqem.irobot.entity.ai.IRobotBrain;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.ai.RobotBrainPackages;
import com.daqem.irobot.item.data.BatteryDataComponent;
import com.daqem.irobot.item.data.IRobotDataComponents;
import com.daqem.irobot.item.data.TaskDataComponent;
import com.daqem.irobot.item.data.TaskMarkerDataComponent;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.menu.RobotMenu;
import com.daqem.irobot.stats.IRobotStats;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Dynamic;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class IRobotEntity
extends TamableAnimal
implements GeoEntity,
InteractableRobot {
    private static final EntityDataAccessor<Boolean> IS_MINING = SynchedEntityData.defineId(IRobotEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_FARMING = SynchedEntityData.defineId(IRobotEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int REGENERATION_COOLDOWN_TICKS = 20;
    private static final double REGENERATION_ENERGY_COST = 10.0;
    private static final float REGENERATION_AMOUNT = 1.0f;
    private static final EnumMap<ModuleItem.ModuleType, ResourceLocation> ATTRIBUTE_MODIFIER_LOCATIONS = new EnumMap(ModuleItem.ModuleType.class);
    protected final RobotInventory inventory;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> IRobotEntity.this.getEntityId();
                case 1 -> Mth.floor((double)IRobotEntity.this.getEnergy());
                case 2 -> Mth.floor((double)IRobotEntity.this.getMaxEnergy());
                case 3 -> IRobotEntity.this.getActiveActivityIndex();
                case 4 -> Mth.floor((float)IRobotEntity.this.getHealth());
                case 5 -> Mth.floor((float)IRobotEntity.this.getMaxHealth());
                default -> 0;
            };
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 6;
        }
    };
    private int regenerationCooldown = 0;
    @Nullable
    private Player interactingPlayer;
    private Vec3 lastPos;
    private double distanceSqAccumulator;

    protected IRobotEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.inventory = new RobotInventory(this, this.equipment);
        this.getNavigation().setCanOpenDoors(true);
        this.getNavigation().setCanFloat(true);
        this.getNavigation().setRequiredPathLength(48.0f);
        this.setCanPickUpLoot(true);
        this.lastPos = this.position();
    }

    public static Activity getActivityByIndex(int index) {
        return switch (index) {
            case 0 -> Activity.IDLE;
            case 1 -> Activity.REST;
            case 2 -> (Activity)IRobotActivities.PROTECT.get();
            case 3 -> (Activity)IRobotActivities.MINE.get();
            case 4 -> (Activity)IRobotActivities.CUT_WOOD.get();
            case 5 -> (Activity)IRobotActivities.FARM.get();
            case 6 -> (Activity)IRobotActivities.FOLLOW.get();
            case 7 -> (Activity)IRobotActivities.RECHARGE.get();
            case 8 -> (Activity)IRobotActivities.DROPOFF.get();
            default -> Activity.IDLE;
        };
    }

    public static int getIndexByActivity(Activity activity) {
        if (activity == Activity.IDLE) {
            return 0;
        }
        if (activity == Activity.REST) {
            return 1;
        }
        if (activity == IRobotActivities.PROTECT.get()) {
            return 2;
        }
        if (activity == IRobotActivities.MINE.get()) {
            return 3;
        }
        if (activity == IRobotActivities.CUT_WOOD.get()) {
            return 4;
        }
        if (activity == IRobotActivities.FARM.get()) {
            return 5;
        }
        if (activity == IRobotActivities.FOLLOW.get()) {
            return 6;
        }
        if (activity == IRobotActivities.RECHARGE.get()) {
            return 7;
        }
        if (activity == IRobotActivities.DROPOFF.get()) {
            return 8;
        }
        return 0;
    }

    public static AttributeSupplier.Builder createRobotAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.BLOCK_BREAK_SPEED, 1.0).add(Attributes.MINING_EFFICIENCY, 0.0).add(Attributes.SUBMERGED_MINING_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public int getActiveActivityIndex() {
        return this.getBrain().getActiveNonCoreActivity().map(IRobotEntity::getIndexByActivity).orElse(0);
    }

    public abstract int getRechargeThreshold();

    protected abstract InteractionResult handleItemInteraction(ServerPlayer var1, ItemStack var2, InteractionHand var3);

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_MINING, (Object)false);
        builder.define(IS_FARMING, (Object)false);
    }

    public boolean isMining() {
        return (Boolean)this.entityData.get(IS_MINING);
    }

    public void setMining(boolean mining) {
        this.entityData.set(IS_MINING, (Object)mining);
    }

    public boolean isFarming() {
        return (Boolean)this.entityData.get(IS_FARMING);
    }

    public void setFarming(boolean farming) {
        this.entityData.set(IS_FARMING, (Object)farming);
    }

    @NotNull
    public Brain<IRobotEntity> getBrain() {
        Brain brain = super.getBrain();
        if (brain instanceof IRobotBrain) {
            IRobotBrain robotBrain = (IRobotBrain)brain;
            robotBrain.irobot$setRobot(this);
        }
        return brain;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<MiniRobotEntity> brainProvider() {
        return RobotBrainPackages.createBrainProvider();
    }

    @NotNull
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        Brain brain = this.brainProvider().makeBrain(dynamic);
        RobotBrainPackages.registerBrainGoals((Brain<MiniRobotEntity>)brain);
        return brain;
    }

    public void aiStep() {
        double distSq;
        super.aiStep();
        if (!this.level().isClientSide && this.lastPos != Vec3.ZERO && (distSq = this.position().distanceToSqr(this.lastPos)) > 0.0) {
            this.distanceSqAccumulator += distSq;
        }
        this.lastPos = this.position();
        this.recalculateAttributes();
    }

    protected void customServerAiStep(ServerLevel level) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("robotBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        profiler.pop();
        profiler.push("robotInventory");
        this.inventory.tick();
        profiler.pop();
        if (this.isAlive()) {
            if (this.tickCount % 20 == 0) {
                double energyCost = this.distanceSqAccumulator / 16.0;
                if (energyCost > 0.0) {
                    this.setEnergy(this.getEnergy() - energyCost * this.getEnergyConsumptionModifier());
                }
                this.distanceSqAccumulator = 0.0;
            }
            this.handleHealthRegeneration();
            this.handleSolarCharging();
        }
        super.customServerAiStep(level);
    }

    private void handleHealthRegeneration() {
        if (this.getHealth() < this.getMaxHealth() && this.getEnergy() >= 10.0) {
            if (this.regenerationCooldown > 0) {
                --this.regenerationCooldown;
            } else {
                this.heal(1.0f);
                this.setEnergy(this.getEnergy() - 10.0 * this.getEnergyConsumptionModifier());
                this.regenerationCooldown = 20;
            }
        }
    }

    private void handleSolarCharging() {
        if (this.hasModule(ModuleItem.ModuleType.SOLAR_PANEL) && this.isDay() && this.level().canSeeSky(this.blockPosition()) && this.tickCount % 20 == 0) {
            double energyToGen = 2.0;
            this.setEnergy(this.getEnergy() + energyToGen);
        }
    }

    private boolean isDay() {
        int i = this.level().getBrightness(LightLayer.SKY, this.blockPosition()) - this.level().getSkyDarken();
        float f = this.level().getSunAngle(1.0f);
        float g = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
        f += (g - f) * 0.2f;
        i = Math.round((float)i * Mth.cos((float)f));
        i = Mth.clamp((int)i, (int)0, (int)15);
        return i >= 8;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        Entity attacker;
        boolean wasHurt = super.hurtServer(level, damageSource, amount);
        if (wasHurt && !this.level().isClientSide() && (attacker = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (attacker instanceof Player) {
                return true;
            }
            this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)livingAttacker);
        }
        return wasHurt;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EntityReference ownerReference = this.getOwnerReference();
            if (ownerReference == null) {
                return InteractionResult.PASS;
            }
            if (!ownerReference.matches((UniquelyIdentifyable)player)) {
                serverPlayer.sendSystemMessage((Component)IRobot.translatable("error.robot.not_owner").withStyle(ChatFormatting.RED), true);
                return InteractionResult.CONSUME;
            }
            ItemStack itemInHand = player.getItemInHand(hand);
            InteractionResult itemResult = this.handleItemInteraction(serverPlayer, itemInHand, hand);
            if (itemResult.consumesAction()) {
                return itemResult;
            }
            if (hand == InteractionHand.MAIN_HAND) {
                player.awardStat((ResourceLocation)IRobotStats.TALKED_TO_ROBOT.get());
            }
            this.startInteracting(serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public void die(DamageSource damageSource) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.STATION_POS.get()).ifPresent(globalPos -> serverLevel.getPoiManager().release(globalPos.pos()));
        }
        super.die(damageSource);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        this.inventory.save((ValueOutput.TypedOutputList<ItemStackWithSlot>)output.list("Inventory", ItemStackWithSlot.CODEC));
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.inventory.load((ValueInput.TypedInputList<ItemStackWithSlot>)input.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
        if (this.level() instanceof ServerLevel) {
            this.recalculateAttributes();
        }
    }

    private void startInteracting(ServerPlayer serverPlayer) {
        this.setInteractingPlayer((Player)serverPlayer);
        this.openScreen(serverPlayer, this.getDisplayName());
    }

    private void openScreen(ServerPlayer serverPlayer, Component title) {
        serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, player) -> new RobotMenu(containerId, playerInventory, this), title));
    }

    @Override
    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    @Nullable
    public Player getInteractingPlayer() {
        return this.interactingPlayer;
    }

    @Override
    public void setInteractingPlayer(@Nullable Player player) {
        this.interactingPlayer = player;
    }

    @Override
    public boolean stillValid(Player player) {
        return this.getInteractingPlayer() == player && this.isAlive() && this.distanceToSqr((Entity)player) < 64.0;
    }

    @Override
    public int getEntityId() {
        return this.getId();
    }

    @Override
    public RobotInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public SlotAccess getSlot(int slot) {
        int i = slot - 300;
        return i >= 0 && i < this.inventory.getContainerSize() ? SlotAccess.forContainer((Container)this.inventory, (int)i) : super.getSlot(slot);
    }

    protected void pickUpItem(ServerLevel level, ItemEntity entity) {
        this.inventory.pickUpItem(level, entity);
    }

    public boolean wantsToPickUp(ServerLevel level, ItemStack stack) {
        return this.inventory.canAddItem(stack);
    }

    protected void dropEquipment(ServerLevel level) {
        this.destroyVanishingCursedItems();
        this.inventory.dropAll();
    }

    protected void destroyVanishingCursedItems() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemStack = this.inventory.getItem(i);
            if (itemStack.isEmpty() || !EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.inventory.removeItemNoUpdate(i);
        }
    }

    public void hurtArmor(DamageSource damageSource, float damageAmount) {
        this.doHurtEquipment(damageSource, damageAmount, new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD});
    }

    public void hurtHelmet(DamageSource damageSource, float damageAmount) {
        this.doHurtEquipment(damageSource, damageAmount, new EquipmentSlot[]{EquipmentSlot.HEAD});
    }

    @NotNull
    protected EntityEquipment createEquipment() {
        return new RobotEquipment(this);
    }

    public float getDestroySpeed(BlockState state) {
        float f = this.inventory.getSelectedItem().getDestroySpeed(state);
        if (f > 1.0f) {
            f += (float)this.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.MINING_FATIGUE)) {
            float g = switch (this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= g;
        }
        f *= (float)this.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(FluidTags.WATER)) {
            f *= (float)this.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!this.onGround()) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean hasCorrectToolForDrops(BlockState state) {
        return !state.requiresCorrectToolForDrops() || this.inventory.getSelectedItem().isCorrectToolForDrops(state);
    }

    public void setBestToolForBlock(BlockState blockState) {
        this.getInventory().setBestToolForBlock(blockState);
    }

    public double getEnergy() {
        ItemStack battery = this.inventory.getBattery();
        if (battery.isEmpty()) {
            return 0.0;
        }
        BatteryDataComponent data = (BatteryDataComponent)battery.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get());
        return data != null ? data.energy() : 0.0;
    }

    public void setEnergy(double energy) {
        BatteryDataComponent data;
        ItemStack battery = this.inventory.getBattery();
        if (!battery.isEmpty() && (data = (BatteryDataComponent)battery.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get())) != null) {
            battery.set((DataComponentType)IRobotDataComponents.BATTERY_DATA.get(), (Object)data.withEnergy(energy));
        }
    }

    public double getMaxEnergy() {
        ItemStack battery = this.inventory.getBattery();
        if (battery.isEmpty()) {
            return 0.0;
        }
        BatteryDataComponent data = (BatteryDataComponent)battery.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get());
        return data != null ? data.maxEnergy() : 0.0;
    }

    public void recalculateAttributes() {
        ImmutableMultimap.Builder allPossibleModifiersBuilder = ImmutableMultimap.builder();
        for (ModuleItem.ModuleType type : ATTRIBUTE_MODIFIER_LOCATIONS.keySet()) {
            double amount = this.getModuleValue(type);
            AttributeModifier.Operation operation = this.getModuleOperation(type);
            ResourceLocation id = ATTRIBUTE_MODIFIER_LOCATIONS.get((Object)type);
            AttributeModifier modifier = new AttributeModifier(id, amount, operation);
            switch (type) {
                case SPEED_BOOST: {
                    allPossibleModifiersBuilder.put((Object)Attributes.MOVEMENT_SPEED, (Object)modifier);
                    break;
                }
                case MINING_SPEED: {
                    allPossibleModifiersBuilder.put((Object)Attributes.MINING_EFFICIENCY, (Object)modifier);
                    break;
                }
                case ATTACK_DAMAGE: {
                    allPossibleModifiersBuilder.put((Object)Attributes.ATTACK_DAMAGE, (Object)modifier);
                    break;
                }
                case DURABILITY: {
                    allPossibleModifiersBuilder.put((Object)Attributes.MAX_HEALTH, (Object)modifier);
                }
            }
        }
        this.getAttributes().removeAttributeModifiers((Multimap)allPossibleModifiersBuilder.build());
        this.getAttributes().addTransientAttributeModifiers(this.createCurrentAttributeMap());
        if (this.getHealth() > this.getMaxHealth()) {
            this.setHealth(this.getMaxHealth());
        }
    }

    private Multimap<Holder<Attribute>, AttributeModifier> createCurrentAttributeMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (ModuleItem module : this.inventory.getEquippedModules()) {
            double amount = this.getModuleValue(module.getType());
            AttributeModifier.Operation operation = this.getModuleOperation(module.getType());
            ResourceLocation id = ATTRIBUTE_MODIFIER_LOCATIONS.get((Object)module.getType());
            if (id == null) continue;
            AttributeModifier modifier = new AttributeModifier(id, amount, operation);
            switch (module.getType()) {
                case SPEED_BOOST: {
                    builder.put((Object)Attributes.MOVEMENT_SPEED, (Object)modifier);
                    break;
                }
                case MINING_SPEED: {
                    builder.put((Object)Attributes.MINING_EFFICIENCY, (Object)modifier);
                    break;
                }
                case ATTACK_DAMAGE: {
                    builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)modifier);
                    break;
                }
                case DURABILITY: {
                    builder.put((Object)Attributes.MAX_HEALTH, (Object)modifier);
                }
            }
        }
        return builder.build();
    }

    private double getModuleValue(ModuleItem.ModuleType type) {
        return switch (type) {
            case ModuleItem.ModuleType.SPEED_BOOST -> 0.5;
            case ModuleItem.ModuleType.MINING_SPEED -> 2.0;
            case ModuleItem.ModuleType.ATTACK_DAMAGE -> 4.0;
            case ModuleItem.ModuleType.DURABILITY -> 20.0;
            default -> 0.0;
        };
    }

    private AttributeModifier.Operation getModuleOperation(ModuleItem.ModuleType type) {
        if (type == ModuleItem.ModuleType.SPEED_BOOST) {
            return AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
        }
        return AttributeModifier.Operation.ADD_VALUE;
    }

    public boolean hasModule(ModuleItem.ModuleType type) {
        return this.inventory.getEquippedModules().stream().anyMatch(m -> m.getType() == type);
    }

    public double getEnergyConsumptionModifier() {
        if (this.hasModule(ModuleItem.ModuleType.BATTERY_EFFICIENCY)) {
            return 0.75;
        }
        return 1.0;
    }

    public boolean needsRecharging() {
        return this.getEnergy() < (double)this.getRechargeThreshold();
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public boolean needsToDropOff() {
        return this.inventory.isMainInventoryFull();
    }

    public boolean hasTaskItem() {
        ItemStack task = this.getInventory().getTask();
        return task != null && !task.isEmpty();
    }

    @Nullable
    public TaskDataComponent getTaskItemData() {
        ItemStack task = this.getInventory().getTask();
        if (task != null && !task.isEmpty() && task.has((DataComponentType)IRobotDataComponents.TASK_DATA.get())) {
            return (TaskDataComponent)task.get((DataComponentType)IRobotDataComponents.TASK_DATA.get());
        }
        return null;
    }

    public TaskMarkerDataComponent getTaskMarkerData() {
        ItemStack task = this.getInventory().getTask();
        if (task != null && !task.isEmpty() && task.has((DataComponentType)IRobotDataComponents.TASK_MARKER_DATA.get())) {
            return (TaskMarkerDataComponent)task.get((DataComponentType)IRobotDataComponents.TASK_MARKER_DATA.get());
        }
        return null;
    }

    public List<ItemEntity> getItemEntitiesAround() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            TaskMarkerDataComponent taskMarkerData;
            ServerLevel serverLevel = (ServerLevel)level;
            AABB searchArea = this.getBoundingBox().inflate(16.0, 3.0, 16.0);
            if (this.hasTaskItem() && (taskMarkerData = this.getTaskMarkerData()) != null && this.level().dimension().equals(taskMarkerData.firstPos().dimension())) {
                searchArea = OutlineRenderer.createBoundingBox(taskMarkerData.firstPos().pos(), taskMarkerData.secondPos().pos()).inflate(2.0);
            }
            return serverLevel.getEntitiesOfClass(ItemEntity.class, searchArea);
        }
        return List.of();
    }

    public boolean hasItemsAround() {
        return this.getItemEntitiesAround().stream().anyMatch(Entity::isAlive);
    }

    public ItemEntity getNearestItemEntity() {
        List<ItemEntity> items = this.getItemEntitiesAround();
        ItemEntity nearestItem = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (ItemEntity item : items) {
            double distanceSq;
            if (!item.isAlive() || this.level().getBlockState(item.blockPosition().below()).isAir() || !((distanceSq = this.distanceToSqr((Entity)item)) < nearestDistanceSq)) continue;
            nearestDistanceSq = distanceSq;
            nearestItem = item;
        }
        return nearestItem;
    }

    public boolean isCharging() {
        return this.getBrain().getActiveNonCoreActivity().orElse(Activity.IDLE).equals(IRobotActivities.RECHARGE.get());
    }

    public boolean isDroppingOffItems() {
        return this.getBrain().getActiveNonCoreActivity().orElse(Activity.IDLE).equals(IRobotActivities.DROPOFF.get());
    }

    public boolean isFollowing() {
        return this.getBrain().getActiveNonCoreActivity().orElse(Activity.IDLE).equals(IRobotActivities.FOLLOW.get());
    }

    static {
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.SPEED_BOOST, IRobot.getId("speed_boost_module"));
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.MINING_SPEED, IRobot.getId("mining_speed_module"));
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.ATTACK_DAMAGE, IRobot.getId("attack_damage_module"));
        ATTRIBUTE_MODIFIER_LOCATIONS.put(ModuleItem.ModuleType.DURABILITY, IRobot.getId("durability_module"));
    }
}

