/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.item.TaskItem;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;

public class MiniRobotEntity
extends IRobotEntity {
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.DOORS_TO_CLOSE, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryModuleType.HURT_BY, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object[])new MemoryModuleType[]{(MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get(), (MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get(), (MemoryModuleType)IRobotMemoryModuleTypes.MINE_TARGET_POS.get(), (MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get(), (MemoryModuleType)IRobotMemoryModuleTypes.STATION_POS.get(), (MemoryModuleType)IRobotMemoryModuleTypes.MINING_DIRECTION.get(), (MemoryModuleType)IRobotMemoryModuleTypes.LANE_DIRECTION.get(), (MemoryModuleType)IRobotMemoryModuleTypes.DROPOFF_TARGET_POS.get(), (MemoryModuleType)IRobotMemoryModuleTypes.IS_CHARING.get(), (MemoryModuleType)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get(), (MemoryModuleType)IRobotMemoryModuleTypes.REPLANT_POS.get(), (MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()});
    public static final ImmutableList<SensorType<? extends Sensor<? super MiniRobotEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY);
    private static final float RECHARGE_THRESHOLD_PERCENTAGE = 0.2f;

    public MiniRobotEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return IRobotEntity.createRobotAttributes();
    }

    @Override
    protected InteractionResult handleItemInteraction(ServerPlayer player, ItemStack itemInHand, InteractionHand hand) {
        if (itemInHand.getItem() instanceof TaskItem) {
            ItemStack currentTask = this.inventory.getTask();
            if (currentTask.isEmpty()) {
                this.inventory.setItem(25, itemInHand.split(1));
                return InteractionResult.SUCCESS;
            }
            player.sendSystemMessage((Component)IRobot.translatable("robot.error.task_slot_full").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController(), new AnimationController("HoldItem", 5, test -> {
            EnumMap geckolibData = (EnumMap)test.getData(DataTickets.EQUIPMENT_BY_SLOT);
            ItemStack mainHandItem = (ItemStack)geckolibData.get(EquipmentSlot.MAINHAND);
            if (mainHandItem != null && !mainHandItem.isEmpty()) {
                return test.setAndContinue(RawAnimation.begin().thenLoop("misc.holdItem"));
            }
            return PlayState.STOP;
        }), new AnimationController("Mining", 0, state -> {
            if (this.isMining()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("attack.swing"));
            }
            return PlayState.STOP;
        })});
    }

    @Override
    public int getRechargeThreshold() {
        return (int)(this.getMaxEnergy() * (double)0.2f);
    }
}

