/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.item.BatteryItem;
import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.module.IModuleItem;
import com.daqem.irobot.item.module.ModuleItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class RobotInventory
implements Container {
    public static final int INVENTORY_SIZE = 24;
    public static final int BATTERY_SLOT_INDEX = 24;
    public static final int TASK_SLOT_INDEX = 25;
    public static final int MODULE_SLOT_1_INDEX = 26;
    public static final int MODULE_SLOT_2_INDEX = 27;
    public static final Int2ObjectMap<EquipmentSlot> EQUIPMENT_SLOT_MAPPING;
    public final IRobotEntity robot;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)28, (Object)ItemStack.EMPTY);
    private final EntityEquipment equipment;
    private int selected;

    public RobotInventory(IRobotEntity robot, EntityEquipment equipment) {
        this.robot = robot;
        this.equipment = equipment;
    }

    public static int getSelectionSize() {
        return 9;
    }

    public static boolean isHotbarSlot(int index) {
        return index >= 0 && index < 9;
    }

    public static boolean isUsableForCrafting(ItemStack stack) {
        return !stack.isDamaged() && !stack.isEnchanted() && !stack.has(DataComponents.CUSTOM_NAME);
    }

    public void pickUpItem(ServerLevel level, ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        if (this.robot.wantsToPickUp(level, itemStack)) {
            boolean bl = this.canAddItem(itemStack);
            if (!bl) {
                return;
            }
            this.robot.onItemPickup(itemEntity);
            int i = itemStack.getCount();
            ItemStack itemStack2 = this.addItem(itemStack);
            this.robot.take((Entity)itemEntity, i - itemStack2.getCount());
            if (itemStack2.isEmpty()) {
                itemEntity.discard();
            } else {
                itemStack.setCount(itemStack2.getCount());
            }
        }
    }

    public boolean canAddItem(ItemStack stack) {
        boolean bl = false;
        for (ItemStack itemStack : this.items) {
            if (!itemStack.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack) || itemStack.getCount() >= itemStack.getMaxStackSize())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack taskSlotStack;
        ItemStack batterySlotStack;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (stack.getItem() instanceof BatteryItem && (batterySlotStack = (ItemStack)this.items.get(24)).isEmpty()) {
            this.items.set(24, (Object)stack.split(1));
            return stack;
        }
        if (stack.getItem() instanceof TaskItem && (taskSlotStack = (ItemStack)this.items.get(25)).isEmpty()) {
            this.items.set(25, (Object)stack.split(1));
            return stack;
        }
        if (stack.getItem() instanceof IModuleItem) {
            if (((ItemStack)this.items.get(26)).isEmpty()) {
                this.items.set(26, (Object)stack.split(1));
                if (stack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
            }
            if (((ItemStack)this.items.get(27)).isEmpty()) {
                this.items.set(27, (Object)stack.split(1));
                if (stack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
            }
        }
        ItemStack itemStack = stack.copy();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.isEmpty() ? ItemStack.EMPTY : itemStack;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return list;
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < 24; ++i) {
            ItemStack itemStack = this.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.isEmpty()) continue;
            return;
        }
    }

    private void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < 24; ++i) {
            ItemStack itemStack = this.getItem(i);
            if (!itemStack.isEmpty()) continue;
            this.setItem(i, stack.copyAndClear());
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack stack, ItemStack other) {
        int i = this.getMaxStackSize(other);
        int j = Math.min(stack.getCount(), i - other.getCount());
        if (j > 0) {
            other.grow(j);
            stack.shrink(j);
            this.setChanged();
        }
    }

    public int getSelectedSlot() {
        return this.selected;
    }

    public void setSelectedSlot(int slot) {
        this.selected = slot;
    }

    public ItemStack getSelectedItem() {
        return (ItemStack)this.items.get(this.selected);
    }

    public ItemStack setSelectedItem(ItemStack stack) {
        return (ItemStack)this.items.set(this.selected, (Object)stack);
    }

    public NonNullList<ItemStack> getNonEquipmentItems() {
        return this.items;
    }

    private boolean hasRemainingSpaceForItem(ItemStack destination, ItemStack origin) {
        return !destination.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)destination, (ItemStack)origin) && destination.isStackable() && destination.getCount() < this.getMaxStackSize(destination);
    }

    public int getFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public boolean isFull() {
        return this.getFreeSlot() == -1;
    }

    public boolean isMainInventoryFull() {
        for (int i = 0; i < 24; ++i) {
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void addAndPickItem(ItemStack stack) {
        int i;
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        if (!((ItemStack)this.items.get(this.selected)).isEmpty() && (i = this.getFreeSlot()) != -1) {
            this.items.set(i, (Object)((ItemStack)this.items.get(this.selected)));
        }
        this.items.set(this.selected, (Object)stack);
    }

    public void pickSlot(int index) {
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        ItemStack itemStack = (ItemStack)this.items.get(this.selected);
        this.items.set(this.selected, (Object)((ItemStack)this.items.get(index)));
        this.items.set(index, (Object)itemStack);
    }

    public int findSlotMatchingItem(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)this.items.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int findSlotMatchingCraftingIngredient(Holder<Item> item, ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.isEmpty() || !itemStack.is(item) || !RobotInventory.isUsableForCrafting(itemStack) || !stack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int j;
        for (int i = 0; i < 9; ++i) {
            j = (this.selected + i) % 9;
            if (!((ItemStack)this.items.get(j)).isEmpty()) continue;
            return j;
        }
        for (int ix = 0; ix < 9; ++ix) {
            j = (this.selected + ix) % 9;
            if (((ItemStack)this.items.get(j)).isEnchanted()) continue;
            return j;
        }
        return this.selected;
    }

    private int addResource(ItemStack stack) {
        int i = this.getSlotWithRemainingSpace(stack);
        if (i == -1) {
            i = this.getFreeSlot();
        }
        return i == -1 ? stack.getCount() : this.addResource(i, stack);
    }

    private int addResource(int slot, ItemStack stack) {
        int j;
        int k;
        int i = stack.getCount();
        ItemStack itemStack = this.getItem(slot);
        if (itemStack.isEmpty()) {
            itemStack = stack.copyWithCount(0);
            this.setItem(slot, itemStack);
        }
        if ((k = Math.min(i, j = this.getMaxStackSize(itemStack) - itemStack.getCount())) != 0) {
            i -= k;
            itemStack.grow(k);
            itemStack.setPopTime(5);
        }
        return i;
    }

    public int getSlotWithRemainingSpace(ItemStack stack) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), stack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem((ItemStack)this.items.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void tick() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.isEmpty()) continue;
            itemStack.inventoryTick(this.robot.level(), (Entity)this.robot, (EquipmentSlot)(i == this.selected ? EquipmentSlot.MAINHAND : null));
        }
    }

    public boolean add(ItemStack stack) {
        return this.add(-1, stack);
    }

    public boolean add(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            int i;
            if (stack.isDamaged()) {
                if (slot == -1) {
                    slot = this.getFreeSlot();
                }
                if (slot >= 0) {
                    this.items.set(slot, (Object)stack.copyAndClear());
                    ((ItemStack)this.items.get(slot)).setPopTime(5);
                    return true;
                }
                if (this.robot.hasInfiniteMaterials()) {
                    stack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                i = stack.getCount();
                if (slot == -1) {
                    stack.setCount(this.addResource(stack));
                    continue;
                }
                stack.setCount(this.addResource(slot, stack));
            } while (!stack.isEmpty() && stack.getCount() < i);
            if (stack.getCount() == i && this.robot.hasInfiniteMaterials()) {
                stack.setCount(0);
                return true;
            }
            return stack.getCount() < i;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)var6, (String)"Adding item to inventory");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Item being added");
            crashReportCategory.setDetail("Item ID", (Object)Item.getId((Item)stack.getItem()));
            crashReportCategory.setDetail("Item data", (Object)stack.getDamageValue());
            crashReportCategory.setDetail("Item name", () -> stack.getHoverName().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void placeItemBackInInventory(ItemStack stack) {
        this.placeItemBackInInventory(stack, true);
    }

    public void placeItemBackInInventory(ItemStack stack, boolean sendPacket) {
        while (!stack.isEmpty()) {
            int i = this.getSlotWithRemainingSpace(stack);
            if (i == -1) {
                i = this.getFreeSlot();
            }
            if (i == -1) {
                this.robot.drop(stack, false, true);
                break;
            }
            int n = stack.getMaxStackSize() - this.getItem(i).getCount();
        }
    }

    public ClientboundSetPlayerInventoryPacket createInventoryUpdatePacket(int slot) {
        return new ClientboundSetPlayerInventoryPacket(slot, this.getItem(slot).copy());
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack;
        if (slot < this.items.size()) {
            return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(slot);
        if (equipmentSlot != null && !(itemStack = this.equipment.get(equipmentSlot)).isEmpty()) {
            return itemStack.split(amount);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != stack) continue;
            this.items.set(i, (Object)ItemStack.EMPTY);
            return;
        }
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            ItemStack itemStack = this.equipment.get(equipmentSlot);
            if (itemStack != stack) continue;
            this.equipment.set(equipmentSlot, ItemStack.EMPTY);
            return;
        }
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot < this.items.size()) {
            ItemStack itemStack = (ItemStack)this.items.get(slot);
            this.items.set(slot, (Object)ItemStack.EMPTY);
            return itemStack;
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(slot);
        return equipmentSlot != null ? this.equipment.set(equipmentSlot, ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
            if (!(this.robot.level().isClientSide() || slot != 26 && slot != 27)) {
                this.robot.recalculateAttributes();
            }
            return;
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(slot);
        if (equipmentSlot != null) {
            this.equipment.set(equipmentSlot, stack);
        }
    }

    public void setChanged() {
    }

    public void save(ValueOutput.TypedOutputList<ItemStackWithSlot> output) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.isEmpty()) continue;
            output.add((Object)new ItemStackWithSlot(i, itemStack));
        }
    }

    public void load(ValueInput.TypedInputList<ItemStackWithSlot> input) {
        this.items.clear();
        for (ItemStackWithSlot itemStackWithSlot : input) {
            if (!itemStackWithSlot.isValidInContainer(this.items.size())) continue;
            this.setItem(itemStackWithSlot.slot(), itemStackWithSlot.stack());
        }
    }

    public int getContainerSize() {
        return this.items.size() + EQUIPMENT_SLOT_MAPPING.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            if (this.equipment.get(equipmentSlot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot < this.items.size()) {
            return (ItemStack)this.items.get(slot);
        }
        EquipmentSlot equipmentSlot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(slot);
        return equipmentSlot != null ? this.equipment.get(equipmentSlot) : ItemStack.EMPTY;
    }

    public void dropAll() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.isEmpty()) continue;
            this.robot.drop(itemStack, true, false);
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
        this.equipment.dropAll((LivingEntity)this.robot);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean contains(ItemStack stack) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TagKey<Item> tag) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.isEmpty() || !itemStack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> predicate) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (!predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(Inventory playerInventory) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, playerInventory.getItem(i));
        }
        this.setSelectedSlot(playerInventory.getSelectedSlot());
    }

    public void clearContent() {
        this.items.clear();
        this.equipment.clear();
    }

    public void fillStackedContents(StackedItemContents contents) {
        for (ItemStack itemStack : this.items) {
            contents.accountSimpleStack(itemStack);
        }
    }

    public ItemStack removeFromSelected(boolean removeStack) {
        ItemStack itemStack = this.getSelectedItem();
        return itemStack.isEmpty() ? ItemStack.EMPTY : this.removeItem(this.selected, removeStack ? itemStack.getCount() : 1);
    }

    public void setBestToolForBlock(BlockState blockState) {
        int bestSlot = -1;
        float bestSpeed = 1.0f;
        for (int i = 0; i < 24; ++i) {
            ItemStack itemStack = this.getItem(i);
            float speed = itemStack.getDestroySpeed(blockState);
            if (!(speed > bestSpeed)) continue;
            bestSpeed = speed;
            bestSlot = i;
        }
        if (bestSlot != -1) {
            this.setSelectedSlot(bestSlot);
        }
    }

    public ItemStack getBattery() {
        return this.getItem(24);
    }

    public ItemStack getTask() {
        return this.getItem(25);
    }

    public boolean canAddItem(Container container) {
        for (int i = 0; i < 24; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            for (int j = 0; j < container.getContainerSize(); ++j) {
                ItemStack conatinerStack = container.getItem(j);
                if (!container.canPlaceItem(j, stack) || !conatinerStack.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)conatinerStack) || conatinerStack.getCount() >= conatinerStack.getMaxStackSize())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasItemsToDropOff() {
        for (int i = 0; i < 24; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty() || stack.isDamageableItem()) continue;
            return true;
        }
        return false;
    }

    public void selectBestWeapon(LivingEntity target) {
        float bestDamage = 1.0f;
        int bestSlot = this.selected;
        for (int i = 0; i < 24; ++i) {
            Optional<Float> optional;
            ItemAttributeModifiers itemAttributeModifiers;
            ItemStack itemStack = this.getItem(i);
            if (itemStack.isEmpty() || (itemAttributeModifiers = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS)) == null || !(optional = itemAttributeModifiers.modifiers().stream().filter(attributeModifier -> attributeModifier.attribute().is(Attributes.ATTACK_DAMAGE)).findFirst().map(attributeModifier -> Float.valueOf((float)attributeModifier.modifier().amount()))).isPresent() || !(optional.get().floatValue() > bestDamage)) continue;
            bestDamage = optional.get().floatValue();
            bestSlot = i;
        }
        this.setSelectedSlot(bestSlot);
    }

    public List<ModuleItem> getEquippedModules() {
        ItemStack module2;
        Item item;
        ArrayList<ModuleItem> modules = new ArrayList<ModuleItem>();
        ItemStack module1 = this.getItem(26);
        Item item2 = module1.getItem();
        if (item2 instanceof ModuleItem) {
            ModuleItem moduleItem = (ModuleItem)item2;
            modules.add(moduleItem);
        }
        if ((item = (module2 = this.getItem(27)).getItem()) instanceof ModuleItem) {
            ModuleItem moduleItem = (ModuleItem)item;
            modules.add(moduleItem);
        }
        return modules;
    }

    static {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        int baseIndex = 28;
        map.put(EquipmentSlot.FEET.getIndex(baseIndex), (Object)EquipmentSlot.FEET);
        map.put(EquipmentSlot.LEGS.getIndex(baseIndex), (Object)EquipmentSlot.LEGS);
        map.put(EquipmentSlot.CHEST.getIndex(baseIndex), (Object)EquipmentSlot.CHEST);
        map.put(EquipmentSlot.HEAD.getIndex(baseIndex), (Object)EquipmentSlot.HEAD);
        EQUIPMENT_SLOT_MAPPING = map;
    }
}

