/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.charging;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.block.IRobotBlocks;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.level.poi.IRobotPoiTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FindRechargeStation
extends Behavior<MiniRobotEntity> {
    public FindRechargeStation() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, MiniRobotEntity robot) {
        boolean isOnStation = level.getBlockState(robot.blockPosition()).is((Block)IRobotBlocks.ROBOT_STATION.get());
        return robot.needsRecharging() && !isOnStation;
    }

    protected void start(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        level.getPoiManager().findClosestWithType(poiTypeHolder -> poiTypeHolder.is(IRobotPoiTypes.ROBOT_STATION.getId()), robot.blockPosition(), 128, PoiManager.Occupancy.HAS_SPACE).ifPresentOrElse(pair -> {
            BlockPos stationPos = (BlockPos)pair.getSecond();
            BlockState stationState = level.getBlockState(stationPos);
            double topY = (double)stationPos.getY() + stationState.getShape((BlockGetter)level, (BlockPos)stationPos).bounds().maxY;
            Vec3 targetVec = new Vec3((double)stationPos.getX() + 0.5, topY, (double)stationPos.getZ() + 0.5);
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetVec, 0.5f, 0));
        }, () -> {
            robot.getBrain().setActiveActivityIfPossible(Activity.REST);
            LivingEntity patt0$temp = robot.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                serverPlayer.sendSystemMessage((Component)IRobot.translatable("robot.error.cant_find_station", robot.getDisplayName(), robot.getX(), robot.getY(), robot.getZ()));
            }
        });
    }
}

