/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.core;

import com.daqem.irobot.entity.IRobotEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.Path;

public class PickUpItemsAround
extends Behavior<IRobotEntity> {
    public PickUpItemsAround() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity owner) {
        return !owner.getInventory().isMainInventoryFull() && owner.hasItemsAround() && !owner.isMining() && !owner.isCharging() && !owner.isDroppingOffItems() && !owner.isFarming();
    }

    protected void start(ServerLevel level, IRobotEntity entity, long gameTime) {
        Path path;
        ItemEntity itemEntity = entity.getNearestItemEntity();
        if (itemEntity != null && itemEntity.isAlive() && (path = entity.getNavigation().createPath((Entity)itemEntity, 0)) != null && path.canReach()) {
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)itemEntity, 0.5f, 0));
        }
    }
}

