/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.dropoff;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;

public class DepositItemsAtDropoff
extends Behavior<IRobotEntity> {
    public DepositItemsAtDropoff() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.DROPOFF_TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, IRobotEntity robot) {
        Optional dropoffPos = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.DROPOFF_TARGET_POS.get());
        return dropoffPos.isPresent() && ((GlobalPos)dropoffPos.get()).pos().closerThan((Vec3i)robot.blockPosition(), 2.0);
    }

    protected void start(ServerLevel level, IRobotEntity robot, long gameTime) {
        robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.DROPOFF_TARGET_POS.get()).ifPresent(globalPos -> {
            BlockEntity blockEntity = level.getBlockEntity(globalPos.pos());
            if (blockEntity instanceof Container) {
                ItemStack taskStack;
                Container container = (Container)blockEntity;
                boolean wasTaskComplete = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).isEmpty();
                for (int i = 0; i < 24; ++i) {
                    ItemStack stackInSlot = robot.getInventory().getItem(i);
                    if (stackInSlot.isEmpty() || stackInSlot.isDamageableItem()) continue;
                    ItemStack remainder = HopperBlockEntity.addItem((Container)robot.getInventory(), (Container)container, (ItemStack)stackInSlot, null);
                    robot.getInventory().setItem(i, remainder);
                }
                if (wasTaskComplete && !(taskStack = robot.getInventory().getTask()).isEmpty()) {
                    HopperBlockEntity.addItem((Container)robot.getInventory(), (Container)container, (ItemStack)taskStack, null);
                    robot.getInventory().removeItemNoUpdate(25);
                }
            }
        });
        robot.getBrain().eraseMemory((MemoryModuleType)IRobotMemoryModuleTypes.DROPOFF_TARGET_POS.get());
        robot.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        robot.getBrain().setActiveActivityIfPossible(Activity.IDLE);
    }
}

