/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.farming;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.util.CropUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class FindFarmableBlock
extends Behavior<MiniRobotEntity> {
    public FindFarmableBlock() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull MiniRobotEntity robot) {
        return robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.FARMING;
    }

    protected void start(@NotNull ServerLevel level, @NotNull MiniRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        AABB searchArea = OutlineRenderer.createBoundingBox(((GlobalPos)startPosOpt.get()).pos(), ((GlobalPos)endPosOpt.get()).pos());
        Optional<BlockPos> matureCrop = this.findClosestMatureCrop(level, robot, searchArea);
        if (matureCrop.isPresent()) {
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)matureCrop.get()));
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(matureCrop.get(), 0.5f, 1));
            return;
        }
        if (robot.hasModule(ModuleItem.ModuleType.CROP_REPLANT)) {
            this.findClosestEmptyFarmland(level, robot, searchArea).ifPresent(emptySpot -> {
                robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.FARM_TARGET_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)emptySpot));
                robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(emptySpot, 0.5f, 1));
            });
        }
    }

    private Optional<BlockPos> findClosestMatureCrop(ServerLevel level, MiniRobotEntity robot, AABB searchArea) {
        return BlockPos.betweenClosedStream((AABB)searchArea).map(BlockPos::immutable).filter(pos -> CropUtils.isFarmableCrop(level.getBlockState(pos)) && CropUtils.isMature(level.getBlockState(pos))).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)robot.blockPosition())));
    }

    private Optional<BlockPos> findClosestEmptyFarmland(ServerLevel level, MiniRobotEntity robot, AABB searchArea) {
        return BlockPos.betweenClosedStream((AABB)searchArea).map(BlockPos::immutable).filter(pos -> level.getBlockState(pos).isAir() && this.isPlantableSpot(level, (BlockPos)pos, robot)).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)robot.blockPosition())));
    }

    private boolean isPlantableSpot(ServerLevel level, BlockPos pos, MiniRobotEntity robot) {
        BlockState ground = level.getBlockState(pos.below());
        if (!ground.is(Blocks.FARMLAND) && !ground.is(Blocks.SOUL_SAND)) {
            return false;
        }
        for (int i = 0; i < robot.getInventory().getContainerSize(); ++i) {
            Item item;
            ItemStack stack = robot.getInventory().getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (!CropUtils.isPlantable(stack.getItem()) || !blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)level, pos)) continue;
            return true;
        }
        return false;
    }
}

