/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.following;

import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.monster.Monster;

public class FollowAndProtectOwner
extends Behavior<MiniRobotEntity> {
    private static final float SPEED_MODIFIER = 0.75f;
    private static final int START_FOLLOWING_DISTANCE_SQ = 36;
    private static final int STOP_FOLLOWING_DISTANCE_SQ = 16;
    private static final int PROTECTION_RANGE_SQ = 256;

    public FollowAndProtectOwner() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, MiniRobotEntity robot) {
        LivingEntity owner = robot.getOwner();
        return owner != null && !robot.isLeashed() && !robot.unableToMoveToOwner();
    }

    protected boolean canStillUse(ServerLevel level, MiniRobotEntity entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity);
    }

    protected void tick(ServerLevel level, MiniRobotEntity robot, long gameTime) {
        LivingEntity owner = robot.getOwner();
        if (owner == null) {
            return;
        }
        Brain<IRobotEntity> brain = robot.getBrain();
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)owner, true));
        Optional<LivingEntity> nearestAttacker = this.findNearestAttacker(robot, owner);
        if (nearestAttacker.isPresent()) {
            brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)nearestAttacker.get());
            return;
        }
        if (robot.shouldTryTeleportToOwner()) {
            brain.eraseMemory(MemoryModuleType.WALK_TARGET);
            robot.tryToTeleportToOwner();
            return;
        }
        double distanceSq = robot.distanceToSqr((Entity)owner);
        if (distanceSq > 36.0) {
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)owner, false), 0.75f, 2));
        } else if (distanceSq < 16.0) {
            brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        }
    }

    private Optional<LivingEntity> findNearestAttacker(MiniRobotEntity robot, LivingEntity owner) {
        return robot.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).flatMap(entities -> entities.stream().filter(entity -> entity instanceof Monster && entity.isAlive()).map(entity -> (Monster)entity).filter(monster -> owner.equals((Object)monster.getTarget())).filter(arg_0 -> ((MiniRobotEntity)robot).hasLineOfSight(arg_0)).filter(monster -> monster.distanceToSqr((Entity)owner) < 256.0).map(monster -> monster).findFirst());
    }
}

