/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity.ai.behavior.woodcutting;

import com.daqem.irobot.client.renderer.OutlineRenderer;
import com.daqem.irobot.entity.MiniRobotEntity;
import com.daqem.irobot.entity.ai.IRobotMemoryModuleTypes;
import com.daqem.irobot.entity.task.RobotTask;
import com.daqem.irobot.item.module.ModuleItem;
import com.daqem.irobot.util.TreeUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FindNextTreeToCut
extends Behavior<MiniRobotEntity> {
    public FindNextTreeToCut() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull MiniRobotEntity robot) {
        return robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.ASSIGNED_TASK.get()).orElse(null) == RobotTask.WOODCUTTING;
    }

    protected void start(@NotNull ServerLevel level, @NotNull MiniRobotEntity robot, long gameTime) {
        Optional startPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_START.get());
        Optional endPosOpt = robot.getBrain().getMemory((MemoryModuleType)IRobotMemoryModuleTypes.TASK_AREA_END.get());
        if (startPosOpt.isEmpty() || endPosOpt.isEmpty()) {
            return;
        }
        BlockPos startPos = ((GlobalPos)startPosOpt.get()).pos();
        BlockPos endPos = ((GlobalPos)endPosOpt.get()).pos();
        AABB searchArea = OutlineRenderer.createBoundingBox(startPos, endPos);
        this.findClosestTree(level, robot, searchArea).ifPresent(treePos -> {
            BlockPos northPos = treePos.north();
            BlockPos southPos = treePos.south();
            BlockPos eastPos = treePos.east();
            BlockPos westPos = treePos.west();
            Vec3 robotVec = robot.position();
            BlockPos bestPos = northPos;
            double shortestDistance = northPos.distToCenterSqr((Position)robotVec);
            if (southPos.distToCenterSqr((Position)robotVec) < shortestDistance) {
                shortestDistance = southPos.distToCenterSqr((Position)robotVec);
                bestPos = southPos;
            }
            if (eastPos.distToCenterSqr((Position)robotVec) < shortestDistance) {
                shortestDistance = eastPos.distToCenterSqr((Position)robotVec);
                bestPos = eastPos;
            }
            if (westPos.distToCenterSqr((Position)robotVec) < shortestDistance) {
                bestPos = westPos;
            }
            robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.TREE_TARGET_POS.get(), (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)treePos));
            robot.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(bestPos, 0.5f, 1));
            if (robot.hasModule(ModuleItem.ModuleType.REFORESTATION)) {
                BlockState logState = level.getBlockState(treePos);
                TreeUtils.getSaplingFromLog(logState).ifPresent(sapling -> {
                    robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.SAPLING_TO_PLANT.get(), sapling);
                    robot.getBrain().setMemory((MemoryModuleType)IRobotMemoryModuleTypes.REPLANT_POS.get(), treePos);
                });
            }
        });
    }

    private Optional<BlockPos> findClosestTree(ServerLevel level, MiniRobotEntity robot, AABB searchArea) {
        BlockPos robotPos = robot.blockPosition();
        return BlockPos.betweenClosedStream((AABB)searchArea).map(BlockPos::immutable).filter(pos -> this.isTreeLog(level, (BlockPos)pos)).filter(pos -> TreeUtils.isTree(level, pos)).map(pos -> TreeUtils.getTreeBase(level, pos)).distinct().min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)robotPos)));
    }

    private boolean isTreeLog(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).is(BlockTags.LOGS);
    }
}

