/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.menu;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.client.entity.ClientSideInteractableRobot;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.entity.InteractableRobot;
import com.daqem.irobot.item.BatteryItem;
import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.module.IModuleItem;
import com.daqem.irobot.menu.ArmorSlot;
import com.daqem.irobot.menu.BatterySlot;
import com.daqem.irobot.menu.IRobotMenuTypes;
import com.daqem.irobot.menu.ModuleSlot;
import com.daqem.irobot.menu.TaskSlot;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.NotNull;

public class RobotMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = IRobot.getId("robot/helmet_empty");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = IRobot.getId("robot/chestplate_empty");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = IRobot.getId("robot/leggings_empty");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = IRobot.getId("robot/boots_empty");
    private static final Map<EquipmentSlot, ResourceLocation> TEXTURE_EMPTY_SLOTS = Map.of(EquipmentSlot.FEET, EMPTY_ARMOR_SLOT_BOOTS, EquipmentSlot.LEGS, EMPTY_ARMOR_SLOT_LEGGINGS, EquipmentSlot.CHEST, EMPTY_ARMOR_SLOT_CHESTPLATE, EquipmentSlot.HEAD, EMPTY_ARMOR_SLOT_HELMET);
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final InteractableRobot robot;

    public RobotMenu(int windowId, Inventory playerInventory, InteractableRobot robot) {
        super((MenuType)IRobotMenuTypes.ROBOT_MENU.get(), windowId);
        int slotX;
        this.robot = robot;
        int baseArmorSlotIndex = 28;
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = SLOT_IDS[i];
            ResourceLocation resourceLocation = TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            this.addSlot(new ArmorSlot(robot.getInventory(), equipmentSlot, baseArmorSlotIndex + (3 - i), 24, 19 + i * 22, resourceLocation));
        }
        this.addSlot(new BatterySlot(robot.getInventory(), 24, 119, 19));
        this.addSlot(new TaskSlot(robot.getInventory(), 25, 119, 41));
        this.addSlot(new ModuleSlot(robot.getInventory(), 26, 119, 63));
        this.addSlot(new ModuleSlot(robot.getInventory(), 27, 119, 85));
        for (slotX = 0; slotX < 6; ++slotX) {
            this.addSlot(new Slot(robot.getInventory(), slotX, 24 + slotX * 19, 187));
        }
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX2 = 0; slotX2 < 6; ++slotX2) {
                this.addSlot(new Slot(robot.getInventory(), slotX2 + slotY * 6 + 6, 24 + slotX2 * 19, slotY * 19 + 122));
            }
        }
        for (slotX = 0; slotX < 9; ++slotX) {
            this.addSlot(new Slot((Container)playerInventory, slotX, slotX * 19 + 160, 187));
        }
        for (slotX = 0; slotX < 9; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                this.addSlot(new Slot((Container)playerInventory, slotX + slotY * 9 + 9, slotX * 19 + 160, slotY * 19 + 122));
            }
        }
        this.addDataSlots(robot.getContainerData());
    }

    public RobotMenu(int i, Inventory inventory) {
        this(i, inventory, new ClientSideInteractableRobot(inventory.player));
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            EquipmentSlot equipmentSlot;
            int armorSlotIndex;
            ItemStack sourceStack = slot.getItem();
            itemStack = sourceStack.copy();
            int containerSize = this.robot.getInventory().getContainerSize();
            if (index < containerSize ? !this.moveItemStackTo(sourceStack, containerSize, this.slots.size(), true) : (sourceStack.getItem() instanceof BatteryItem ? !this.moveItemStackTo(sourceStack, 4, 5, false) : (sourceStack.getItem() instanceof TaskItem ? !this.moveItemStackTo(sourceStack, 5, 6, false) : (sourceStack.getItem() instanceof IModuleItem ? !this.moveItemStackTo(sourceStack, 6, 8, false) : (sourceStack.get(DataComponents.EQUIPPABLE) != null ? !this.moveItemStackTo(sourceStack, armorSlotIndex = 3 - (equipmentSlot = ((Equippable)sourceStack.get(DataComponents.EQUIPPABLE)).slot()).getIndex(), armorSlotIndex + 1, false) && !this.moveItemStackTo(sourceStack, 8, containerSize, false) : (index >= containerSize && index < containerSize + 27 ? !this.moveItemStackTo(sourceStack, containerSize + 27, this.slots.size(), false) : (index >= containerSize + 27 && index < this.slots.size() ? !this.moveItemStackTo(sourceStack, containerSize, containerSize + 27, false) : !this.moveItemStackTo(sourceStack, 8, containerSize, false)))))))) {
                return ItemStack.EMPTY;
            }
            if (sourceStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.robot.stillValid(player);
    }

    public int getRobotEntityId() {
        return this.robot.getEntityId();
    }

    public int getEnergy() {
        return this.robot.getContainerData().get(1);
    }

    public int getMaxEnergy() {
        return this.robot.getContainerData().get(2);
    }

    public int getActiveActivityIndex() {
        return this.robot.getContainerData().get(3);
    }

    public Activity getActiveActivity() {
        int index = this.getActiveActivityIndex();
        return IRobotEntity.getActivityByIndex(index);
    }

    public int getHealth() {
        return this.robot.getContainerData().get(4);
    }

    public int getMaxHealth() {
        return this.robot.getContainerData().get(5);
    }
}

