/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valkyrienwarium.ships;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Stack;
import net.mcreator.valkyrienwarium.ships.ForceData;
import net.mcreator.valkyrienwarium.ships.ForceDirectionMode;
import net.mcreator.valkyrienwarium.ships.ForceMode;
import net.mcreator.valkyrienwarium.ships.RotData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ForceInducedShips
implements ShipForcesInducer {
    public Stack<Pair<BlockPos, ForceData>> nextTickForces = new Stack();
    public Stack<RotData> nextTickRotations = new Stack();
    public HashMap<String, Number> numData = new HashMap();
    public HashMap<String, Boolean> boolData = new HashMap();
    public HashMap<String, String> strData = new HashMap();

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl physShip = (PhysShipImpl)physicShip;
        while (!this.nextTickRotations.isEmpty()) {
            RotData data = this.nextTickRotations.pop();
            if (data.mode == ForceMode.GLOBAL) {
                physShip.applyInvariantTorque((Vector3dc)data.rot);
                continue;
            }
            physShip.applyRotDependentTorque((Vector3dc)data.rot);
        }
        while (!this.nextTickForces.isEmpty()) {
            Pair<BlockPos, ForceData> pair = this.nextTickForces.pop();
            BlockPos pos = (BlockPos)pair.getFirst();
            ForceData data = (ForceData)pair.getSecond();
            double throttle = data.throttle;
            if (throttle == 0.0) continue;
            Vector3d direction = data.dirMode == ForceDirectionMode.SHIP ? physShip.getTransform().getShipToWorld().transformDirection((Vector3dc)data.dir, new Vector3d()) : data.dir;
            direction.mul(throttle);
            if (data.mode == ForceMode.GLOBAL) {
                physShip.applyInvariantForce((Vector3dc)direction);
                continue;
            }
            Vector3d tPos = VectorConversionsMCKt.toJOMLD((Vec3i)pos).add(0.5, 0.5, 0.5, new Vector3d()).sub(physShip.getTransform().getPositionInShip());
            physShip.applyInvariantForceToPos((Vector3dc)direction, (Vector3dc)tPos);
        }
    }

    public void addForce(BlockPos pos, ForceData data) {
        this.nextTickForces.push((Pair<BlockPos, ForceData>)new Pair((Object)pos, (Object)data));
    }

    public void addForce(BlockPos pos, Vector3d dir, double throttle, ForceMode mode, ForceDirectionMode dirMode) {
        this.nextTickForces.push((Pair<BlockPos, ForceData>)new Pair((Object)pos, (Object)new ForceData(dir, throttle, mode, dirMode)));
    }

    public void addRotation(RotData data) {
        this.nextTickRotations.push(data);
    }

    public void addRotation(Vector3d rot, ForceMode mode) {
        this.nextTickRotations.push(new RotData(rot, mode));
    }

    public void addNumData(String key, Number obj) {
        this.numData.put(key, obj);
    }

    public void addBoolData(String key, Boolean obj) {
        this.boolData.put(key, obj);
    }

    public void addStrData(String key, String obj) {
        this.strData.put(key, obj);
    }

    public Number getNumData(String key) {
        if (this.numData.containsKey(key)) {
            return this.numData.get(key);
        }
        return 0;
    }

    public Boolean getBoolData(String key) {
        if (this.boolData.containsKey(key)) {
            return this.boolData.get(key);
        }
        return false;
    }

    public String getStrData(String key) {
        if (this.strData.containsKey(key)) {
            return this.strData.get(key);
        }
        return "";
    }

    public static ForceInducedShips getOrCreate(ServerShip ship) {
        ForceInducedShips attachment = (ForceInducedShips)ship.getAttachment(ForceInducedShips.class);
        if (attachment == null) {
            attachment = new ForceInducedShips();
            ship.saveAttachment(ForceInducedShips.class, (Object)attachment);
        }
        return attachment;
    }

    public static ForceInducedShips get(Level level, BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)level;
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        if (ship == null) {
            ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)pos);
        }
        return ship != null ? ForceInducedShips.getOrCreate((ServerShip)ship) : null;
    }
}

