/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valkyrienwarium.ships;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mcreator.valkyrienwarium.mixins.ServerShipObjectWorldAccessor;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityServer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.DimensionIdProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class TeleportHandler {
    private static final Map<Long, Set<Integer>> shipIdToConstraints = ((ServerShipObjectWorldAccessor)VSGameUtilsKt.getShipObjectWorld((MinecraftServer)ValkyrienSkiesMod.getCurrentServer())).getShipIdToConstraints();
    private static final Map<Integer, VSConstraint> constraintIdToConstraint = ((ServerShipObjectWorldAccessor)VSGameUtilsKt.getShipObjectWorld((MinecraftServer)ValkyrienSkiesMod.getCurrentServer())).getConstraints();
    private final Map<Long, Vector3d> shipToPos = new HashMap<Long, Vector3d>();
    private final ServerShipWorldCore shipWorld;
    private double greatestOffset;
    private final ServerLevel newDim;
    private final ServerLevel originalDim;
    private final boolean highestShipPriority;

    public TeleportHandler(ServerLevel newDim, ServerLevel originalDim, boolean highestShipPriority) {
        this.shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)newDim);
        this.newDim = newDim;
        this.originalDim = originalDim;
        this.highestShipPriority = highestShipPriority;
    }

    public void handleTeleport(Ship ship, Vector3d newPos) {
        ServerShip posShip;
        if (VSGameUtilsKt.isBlockInShipyard((Level)this.newDim, (double)newPos.x, (double)newPos.y, (double)newPos.z) && (posShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)this.newDim, (Vector3dc)newPos)) != null) {
            newPos = posShip.getTransform().getShipToWorld().transformPosition(newPos);
        }
        this.collectShips(ship, newPos);
        this.handleTeleport();
    }

    private void collectConnected(Long currentPhysObject, Vector3dc origin, Vector3d newPos) {
        if (currentPhysObject == null) {
            return;
        }
        if (this.shipToPos.containsKey(currentPhysObject)) {
            return;
        }
        Set<Integer> constraints = shipIdToConstraints.get(currentPhysObject);
        Vector3dc pos = TeleportHandler.transformFromId(currentPhysObject, this.shipWorld).getPositionInWorld();
        double offset = pos.get(1) - origin.get(1);
        if ((offset *= this.highestShipPriority ? 1.0 : -1.0) > this.greatestOffset) {
            this.greatestOffset = offset;
        }
        this.shipToPos.put(currentPhysObject, pos.sub(origin, new Vector3d()).add((Vector3dc)newPos, new Vector3d()));
        if (constraints != null) {
            constraints.iterator().forEachRemaining(id -> {
                VSConstraint constraint = constraintIdToConstraint.get(id);
                this.collectConnected(constraint.getShipId0(), origin, newPos);
                this.collectConnected(constraint.getShipId1(), origin, newPos);
            });
        }
    }

    private void collectShips(Ship ship, Vector3d newPos) {
        Vector3dc origin = ship.getTransform().getPositionInWorld();
        this.collectConnected(ship.getId(), origin, newPos);
        this.collectNearby(origin, newPos);
    }

    private void collectNearby(Vector3dc origin, Vector3d newPos) {
        HashMap newShipToPos = new HashMap();
        this.shipToPos.keySet().forEach(id -> {
            if (this.shipToPos.containsKey(id)) {
                return;
            }
            QueryableShipData loadedShips = this.shipWorld.getLoadedShips();
            Ship ship = loadedShips.getById(id.longValue());
            if (ship == null) {
                return;
            }
            loadedShips.getIntersecting((AABBdc)VectorConversionsMCKt.toJOML((AABB)VectorConversionsMCKt.toMinecraft((AABBdc)ship.getWorldAABB()).m_82400_(10.0))).forEach(intersecting -> newShipToPos.put(intersecting.getId(), intersecting.getTransform().getPositionInWorld().sub(origin, new Vector3d()).add((Vector3dc)newPos, new Vector3d())));
        });
        this.shipToPos.putAll(newShipToPos);
    }

    private void handleTeleport() {
        this.greatestOffset *= this.highestShipPriority ? -1.0 : 1.0;
        this.shipToPos.forEach((id, newPos) -> {
            this.dismountEntities((Long)id);
            this.handleShipTeleport((Long)id, (Vector3d)newPos);
        });
    }

    private void dismountEntities(Long id) {
        ServerShip ship = (ServerShip)this.shipWorld.getLoadedShips().getById(id.longValue());
        if (ship == null) {
            return;
        }
        AABB inflatedAABB = VectorConversionsMCKt.toMinecraft((AABBdc)ship.getWorldAABB()).m_82400_(20.0);
        this.originalDim.m_45933_(null, inflatedAABB).forEach(entity -> entity.m_142098_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
    }

    private void handleShipTeleport(Long id, Vector3d newPos) {
        String vsDimName = ((DimensionIdProvider)this.newDim).getDimensionId();
        ServerShip ship = (ServerShip)this.shipWorld.getLoadedShips().getById(id.longValue());
        if (ship == null) {
            PhysicsEntityServer physEntity = (PhysicsEntityServer)((ShipObjectServerWorld)this.shipWorld).getLoadedPhysicsEntities().get(id);
            if (physEntity == null) {
                return;
            }
            ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl((Vector3dc)newPos.add(0.0, this.greatestOffset, 0.0), physEntity.getShipTransform().getShipToWorldRotation(), (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), vsDimName, null);
            this.shipWorld.teleportPhysicsEntity(physEntity, (ShipTeleportData)teleportData);
        }
        ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl((Vector3dc)newPos.add(0.0, this.greatestOffset, 0.0), ship.getTransform().getShipToWorldRotation(), (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), vsDimName, null);
        this.shipWorld.teleportShip(ship, (ShipTeleportData)teleportData);
    }

    private static ShipTransform transformFromId(Long id, ServerShipWorldCore shipWorld) {
        Ship ship = shipWorld.getAllShips().getById(id.longValue());
        if (ship == null) {
            PhysicsEntityServer physicsEntity = (PhysicsEntityServer)((ShipObjectServerWorld)shipWorld).getLoadedPhysicsEntities().get(id);
            if (physicsEntity == null) {
                return new ShipTransformImpl((Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), (Quaterniondc)new Quaterniond(), (Vector3dc)new Vector3d());
            }
            return physicsEntity.getShipTransform();
        }
        return ship.getTransform();
    }

    public static ServerLevel dimToLevel(String dimensionString) {
        MinecraftServer server = ValkyrienSkiesMod.getCurrentServer();
        if (server == null) {
            return null;
        }
        return server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionString)));
    }
}

