/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.iafenvoy.create.shape.item.ShapeItem;
import com.iafenvoy.create.shape.item.block.CutProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.entity.ProcessMachineBlockEntity;
import com.iafenvoy.create.shape.registry.CSCBlockEntities;
import com.iafenvoy.create.shape.registry.CSCBlocks;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.iafenvoy.create.shape.shape.ShapeInfo;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CutProcessMachineBlockEntity
extends ProcessMachineBlockEntity {
    private final Function<ShapeInfo, List<ShapeInfo>> processor;
    protected final NonNullList<ItemStack> outputs = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);

    public CutProcessMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSCBlockEntities.CUT_PROCESS_MACHINE.get(), pos, state);
        Block block = state.getBlock();
        if (!(block instanceof CutProcessMachineBlock)) {
            throw new IllegalArgumentException("CutProcessMachineBlockEntity need a block with CutProcessMachineBlock");
        }
        CutProcessMachineBlock provider = (CutProcessMachineBlock)block;
        this.processor = provider.getProcessor();
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("outputs"), this.outputs, (HolderLookup.Provider)registries);
    }

    @Override
    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        CompoundTag compoundTag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.outputs, (HolderLookup.Provider)registries);
        tag.put("outputs", (Tag)compoundTag);
    }

    @Override
    protected void process() {
        ItemStack stack;
        int i;
        ShapeInfo info = (ShapeInfo)this.inputStack.get(CSCDataComponents.SHAPE);
        if (this.inputStack.isEmpty() || info == null) {
            return;
        }
        List<ItemStack> results = this.processor.apply(info).stream().map(ShapeItem::fromInfo).toList();
        boolean success = true;
        for (i = 0; i < results.size(); ++i) {
            stack = (ItemStack)this.outputs.get(i);
            success &= stack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)results.get(i)) && stack.getCount() < 4;
        }
        if (success) {
            for (i = 0; i < results.size(); ++i) {
                stack = (ItemStack)this.outputs.get(i);
                if (stack.isEmpty()) {
                    this.outputs.set(i, (Object)results.get(i));
                    continue;
                }
                stack.grow(1);
            }
            this.inputStack.shrink(1);
            this.setChanged();
        }
    }

    @Override
    protected void distributeOutputs() {
        this.outputs.replaceAll(this::distributeStack);
    }

    @Override
    protected List<ItemStack> grabOutputs() {
        return this.getBlockState().is(CSCBlocks.CUTTER_QUARTER) ? this.outputs : this.outputs.subList(0, 2);
    }
}

