/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.shape;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ShapeInfo(List<Layer> layers) {
    public static final int MAX_LAYERS = 4;
    public static final String EMPTY_SLUG = "-";
    public static final String LAYER_SEPARATOR = ":";
    public static final Codec<ShapeInfo> CODEC = Codec.STRING.xmap(ShapeInfo::parse, ShapeInfo::toString);
    public static final StreamCodec<ByteBuf, ShapeInfo> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ShapeInfo::parse, ShapeInfo::toString);
    public static final ShapeInfo EMPTY = ShapeInfo.parse("");
    public static final ShapeInfo DEFAULT = ShapeInfo.parse("CuCuCuCu");

    public ShapeInfo(List<Layer> layers) {
        this.layers = layers.stream().filter(x -> !x.isEmpty()).toList();
    }

    @Override
    @NotNull
    public String toString() {
        return String.join((CharSequence)LAYER_SEPARATOR, this.layers.stream().map(Layer::toString).toList());
    }

    @NotNull
    public static ShapeInfo parse(String key) {
        return new ShapeInfo(Arrays.stream(key.split(LAYER_SEPARATOR)).map(Layer::parse).toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        List<Layer> layers1;
        if (!(obj instanceof ShapeInfo)) return false;
        ShapeInfo shapeInfo = (ShapeInfo)obj;
        try {
            List<Layer> list;
            layers1 = list = shapeInfo.layers();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (this.layers.size() != layers1.size()) {
            return false;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            if (Objects.equals(this.layers.get(i), layers1.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.layers.isEmpty();
    }

    public record Layer(EnumMap<Quarter, Part> parts) {
        public static final Layer EMPTY = new Layer(x -> Part.EMPTY);

        public Layer(Function<Quarter, Part> function) {
            this((EnumMap)Util.make(new EnumMap(Quarter.class), map -> Quarter.stream().forEach(x -> map.put(x, (Part)function.apply((Quarter)((Object)x))))));
        }

        public boolean isEmpty() {
            return this == EMPTY || this.parts.values().stream().allMatch(Part::isEmpty);
        }

        @Override
        @NotNull
        public String toString() {
            return Quarter.stream().map(this.parts::get).map(Part::toString).reduce(new StringBuilder(), StringBuilder::append, StringBuilder::append).toString();
        }

        @NotNull
        public static Layer parse(String key) {
            if (key.length() != 8) {
                return EMPTY;
            }
            return new Layer(x -> Part.parse(key.substring(x.ordinal() * 2, x.ordinal() * 2 + 2)));
        }

        public Layer collect(Quarter ... quarters) {
            List<Quarter> list = List.of(quarters);
            return new Layer(x -> list.contains(x) ? this.parts.get(x) : Part.EMPTY);
        }

        public Layer withColor(Color color) {
            return this.withColor((EnumMap)Util.make(new EnumMap(Quarter.class), map -> Quarter.stream().forEach(x -> map.put(x, color))));
        }

        public Layer withColor(EnumMap<Quarter, Color> colors) {
            return new Layer(x -> this.parts.get(x).withColor((Color)((Object)((Object)colors.get(x)))));
        }

        public Layer rotate(Function<Quarter, Quarter> mapping) {
            return new Layer(x -> this.parts.get(mapping.apply((Quarter)((Object)x))));
        }

        public static Optional<Layer> combine(Layer l1, Layer l2) {
            return l1 == null || l2 == null || Quarter.stream().anyMatch(x -> !l1.parts.get(x).isEmpty() && !l2.parts.get(x).isEmpty()) ? Optional.empty() : Optional.of(new Layer(x -> l1.parts.get(x).isEmpty() ? l2.parts.get(x) : l1.parts.get(x)));
        }
    }

    public static enum Quarter implements StringRepresentable
    {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        TOP_LEFT;

        public static final Codec<Quarter> CODEC;
        public static final StreamCodec<ByteBuf, Quarter> STREAM_CODEC;

        public static Stream<Quarter> stream() {
            return Stream.of(Quarter.values());
        }

        public Quarter cycle(boolean clockwise) {
            Quarter[] types = Quarter.values();
            return types[(this.ordinal() + (clockwise ? 1 : types.length - 1)) % types.length];
        }

        public String getTranslateKey() {
            return "quarter.%s.%s".formatted("create_shape_craft", this.getSerializedName());
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Quarter::values);
            STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        }
    }

    public static enum Color {
        RED(ChatFormatting.RED, "r"),
        GREEN(ChatFormatting.GREEN, "g"),
        BLUE(ChatFormatting.BLUE, "b"),
        YELLOW(ChatFormatting.YELLOW, "y"),
        PURPLE(ChatFormatting.LIGHT_PURPLE, "p"),
        CYAN(ChatFormatting.AQUA, "c"),
        UNCOLORED(ChatFormatting.GRAY, "u"),
        WHITE(ChatFormatting.WHITE, "w");

        private final ChatFormatting color;
        private final String slug;

        private Color(ChatFormatting color, String slug) {
            this.color = color;
            this.slug = slug;
        }

        public ChatFormatting getFormatting() {
            return this.color;
        }

        public int getColor() {
            Integer i = this.color.getColor();
            return i == null ? -1 : i;
        }

        public String getSlug() {
            return this.slug;
        }

        @Nullable
        public static Color fromSlug(String slug) {
            return Arrays.stream(Color.values()).filter(x -> Objects.equals(x.getSlug(), slug)).findAny().orElse(null);
        }
    }

    public static enum Shape {
        CIRCLE("circle", "C"),
        RECTANGLE("rectangle", "R"),
        WIND_MILL("wind_mill", "W"),
        STAR("star", "S");

        private final String texture;
        private final String slug;

        private Shape(String texture, String slug) {
            this.texture = texture;
            this.slug = slug;
        }

        public ResourceLocation getBorderTexture() {
            return ResourceLocation.tryBuild((String)"create_shape_craft", (String)"textures/item/shape/%s_border.png".formatted(this.texture));
        }

        public ResourceLocation getInnerTexture() {
            return ResourceLocation.tryBuild((String)"create_shape_craft", (String)"textures/item/shape/%s_inner.png".formatted(this.texture));
        }

        public String getSlug() {
            return this.slug;
        }

        @Nullable
        public static Shape fromSlug(String slug) {
            return Arrays.stream(Shape.values()).filter(x -> Objects.equals(x.getSlug(), slug)).findAny().orElse(null);
        }
    }

    public record Part(Shape shape, Color color) {
        public static final Part EMPTY = new Part(null, null);

        public boolean isEmpty() {
            return this == EMPTY || this.shape == null || this.color == null;
        }

        @Override
        @NotNull
        public String toString() {
            return (this.shape == null ? ShapeInfo.EMPTY_SLUG : this.shape.getSlug()) + (this.color == null ? ShapeInfo.EMPTY_SLUG : this.color.getSlug());
        }

        @NotNull
        public static Part parse(String key) {
            return key.length() != 2 ? EMPTY : new Part(Shape.fromSlug(key.substring(0, 1)), Color.fromSlug(key.substring(1, 2)));
        }

        public Part withColor(Color color) {
            return new Part(this.shape, color);
        }
    }
}

