/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.data;

import com.iafenvoy.create.shape.data.ShapeColor;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ColorMixData {
    private static final List<MixHolder> MIXES = new LinkedList<MixHolder>();

    public static void register(ShapeColor input1, ShapeColor input2, ShapeColor output) {
        MIXES.add(new MixHolder(input1, input2, output));
    }

    @Nullable
    public static ShapeColor getOutput(ShapeColor input1, ShapeColor input2) {
        return MIXES.stream().filter(x -> x.match(input1, input2)).findAny().map(MixHolder::output).orElse(null);
    }

    static {
        ColorMixData.register(ShapeColor.RED, ShapeColor.GREEN, ShapeColor.YELLOW);
        ColorMixData.register(ShapeColor.RED, ShapeColor.BLUE, ShapeColor.PURPLE);
        ColorMixData.register(ShapeColor.GREEN, ShapeColor.BLUE, ShapeColor.CYAN);
        ColorMixData.register(ShapeColor.BLUE, ShapeColor.YELLOW, ShapeColor.WHITE);
        ColorMixData.register(ShapeColor.GREEN, ShapeColor.PURPLE, ShapeColor.WHITE);
        ColorMixData.register(ShapeColor.RED, ShapeColor.CYAN, ShapeColor.WHITE);
    }

    private record MixHolder(ShapeColor input1, ShapeColor input2, ShapeColor output) {
        public boolean match(ShapeColor input1, ShapeColor input2) {
            return this.input1 == input1 && this.input2 == input2 || this.input1 == input2 && this.input2 == input1;
        }
    }
}

