/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.create.shape.data.ShapeColor;
import com.iafenvoy.create.shape.data.ShapeInfo;
import com.iafenvoy.create.shape.data.ShapeQuarter;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class ShapeProcessors {
    public static List<ShapeInfo> cutVertical(ShapeInfo info) {
        return Stream.of(new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.BOTTOM_LEFT, ShapeQuarter.TOP_LEFT)).toList()), new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.TOP_RIGHT, ShapeQuarter.BOTTOM_RIGHT)).toList())).filter(x -> !x.isEmpty()).toList();
    }

    public static List<ShapeInfo> cutHorizontal(ShapeInfo info) {
        return Stream.of(new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.TOP_RIGHT, ShapeQuarter.TOP_LEFT)).toList()), new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.BOTTOM_RIGHT, ShapeQuarter.BOTTOM_LEFT)).toList())).filter(x -> !x.isEmpty()).toList();
    }

    public static List<ShapeInfo> cutQuarter(ShapeInfo info) {
        return Stream.of(new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.TOP_RIGHT)).toList()), new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.BOTTOM_RIGHT)).toList()), new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.BOTTOM_LEFT)).toList()), new ShapeInfo(info.layers().stream().map(x -> x.collect(ShapeQuarter.TOP_LEFT)).toList())).filter(x -> !x.isEmpty()).toList();
    }

    public static ShapeInfo rotateClockwise(ShapeInfo info) {
        return new ShapeInfo(info.layers().stream().map(x -> x.rotate(q -> q.cycle(false))).toList());
    }

    public static ShapeInfo rotateCounterclockwise(ShapeInfo info) {
        return new ShapeInfo(info.layers().stream().map(x -> x.rotate(q -> q.cycle(true))).toList());
    }

    public static ShapeInfo rotate180(ShapeInfo info) {
        return new ShapeInfo(info.layers().stream().map(x -> x.rotate(q -> q.cycle(false).cycle(false))).toList());
    }

    public static ShapeInfo stack(ShapeInfo base, ShapeInfo upper) {
        List<ShapeInfo.Layer> baseLayers = base.layers();
        List<ShapeInfo.Layer> upperLayers = upper.layers();
        int maxCoincide = Math.min(baseLayers.size(), upperLayers.size());
        ShapeInfo result = new ShapeInfo((List<ShapeInfo.Layer>)ImmutableList.builder().addAll(baseLayers).addAll(upperLayers).build());
        for (int i = 1; i <= maxCoincide; ++i) {
            int j;
            int upperHeight = baseLayers.size() - i;
            LinkedList<ShapeInfo.Layer> layers = new LinkedList<ShapeInfo.Layer>();
            for (int j2 = 0; j2 < upperHeight; ++j2) {
                layers.add(baseLayers.get(j2));
            }
            boolean failed = false;
            for (j = 0; j < i; ++j) {
                Optional<ShapeInfo.Layer> optional = ShapeInfo.Layer.combine(baseLayers.get(j + upperHeight), upperLayers.get(j));
                if (optional.isEmpty()) {
                    failed = true;
                    break;
                }
                layers.add(optional.get());
            }
            if (failed) break;
            for (j = i; j < upperLayers.size(); ++j) {
                layers.add(upperLayers.get(j));
            }
            result = new ShapeInfo(List.copyOf(layers));
        }
        return result;
    }

    public static ShapeInfo color(ShapeInfo info, ShapeColor color) {
        return new ShapeInfo(info.layers().stream().map(x -> x.withColor(color)).toList());
    }

    public static ShapeInfo color(ShapeInfo info, EnumMap<ShapeQuarter, ShapeColor> colors) {
        return new ShapeInfo(info.layers().stream().map(x -> x.withColor(colors)).toList());
    }
}

