/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item;

import com.iafenvoy.create.shape.data.ShapeInfo;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.iafenvoy.create.shape.registry.CSCItems;
import com.iafenvoy.create.shape.render.item.ShapeItemRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ShapeItem
extends Item {
    public ShapeItem() {
        super(new Item.Properties().component(CSCDataComponents.SHAPE, (Object)ShapeInfo.DEFAULT));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, components, flag);
        ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
        if (info != null) {
            components.add((Component)Component.literal((String)info.toString()));
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
        if (info == null || info.isEmpty()) {
            stack.setCount(0);
        }
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ShapeItemRenderer();
            }
        });
    }

    public static ItemStack fromKey(String key) {
        return ShapeItem.fromInfo(ShapeInfo.parse(key));
    }

    public static ItemStack fromInfo(ShapeInfo info) {
        ItemStack stack = CSCItems.SHAPE.toStack();
        stack.set(CSCDataComponents.SHAPE, (Object)info);
        return stack;
    }
}

