/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.attribute;

import com.iafenvoy.create.shape.data.ShapeInfo;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ShapeKeyAttribute(ShapeInfo info) implements ItemAttribute
{
    public static final MapCodec<ShapeKeyAttribute> CODEC = ShapeInfo.CODEC.xmap(ShapeKeyAttribute::new, ShapeKeyAttribute::info).fieldOf("value");
    public static final StreamCodec<ByteBuf, ShapeKeyAttribute> STREAM_CODEC = ShapeInfo.STREAM_CODEC.map(ShapeKeyAttribute::new, ShapeKeyAttribute::info);

    public boolean appliesTo(ItemStack stack, Level world) {
        ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
        return info != null && info.equals(this.info);
    }

    public ItemAttributeType getType() {
        return Type.INSTANCE;
    }

    public String getTranslationKey() {
        return "shape_key";
    }

    public Object[] getTranslationParameters() {
        return new String[]{this.info.toString()};
    }

    public static enum Type implements ItemAttributeType
    {
        INSTANCE;


        @NotNull
        public ItemAttribute createAttribute() {
            return new ShapeKeyAttribute(ShapeInfo.DEFAULT);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
            return info == null ? List.of() : List.of(new ShapeKeyAttribute(info));
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

