/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.attribute;

import com.iafenvoy.create.shape.data.ShapeInfo;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ShapeLayerCountAttribute(int layer) implements ItemAttribute
{
    public static final MapCodec<ShapeLayerCountAttribute> CODEC = Codec.INT.xmap(ShapeLayerCountAttribute::new, ShapeLayerCountAttribute::layer).fieldOf("value");
    public static final StreamCodec<ByteBuf, ShapeLayerCountAttribute> STREAM_CODEC = ByteBufCodecs.INT.map(ShapeLayerCountAttribute::new, ShapeLayerCountAttribute::layer);

    public boolean appliesTo(ItemStack stack, Level world) {
        ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
        return info != null && info.layers().size() == this.layer;
    }

    public ItemAttributeType getType() {
        return Type.INSTANCE;
    }

    public String getTranslationKey() {
        return "shape_layer_count";
    }

    public Object[] getTranslationParameters() {
        return new String[]{String.valueOf(this.layer)};
    }

    public static enum Type implements ItemAttributeType
    {
        INSTANCE;


        @NotNull
        public ItemAttribute createAttribute() {
            return new ShapeLayerCountAttribute(0);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
            return info == null ? List.of() : List.of(new ShapeLayerCountAttribute(info.layers().size()));
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

